/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServicesManager;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;

public final class RegisteredServiceSimpleFormController
extends SimpleFormController {
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final IPersonAttributeDao personAttributeDao;

    public RegisteredServiceSimpleFormController(ServicesManager servicesManager, IPersonAttributeDao attributeRepository) {
        this.servicesManager = servicesManager;
        this.personAttributeDao = attributeRepository;
    }

    protected final void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.setRequiredFields(new String[]{"description", "serviceId", "name", "allowedToProxy", "enabled", "ssoEnabled", "anonymousAccess"});
        binder.setDisallowedFields(new String[]{"id"});
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
    }

    protected final ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        RegisteredService service = (RegisteredService)command;
        this.servicesManager.save(service);
        ModelAndView modelAndView = new ModelAndView((View)new RedirectView("/services/manage.html#" + service.getId(), true));
        modelAndView.addObject("action", (Object)"add");
        modelAndView.addObject("id", (Object)service.getId());
        return modelAndView;
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (!StringUtils.hasText((String)id)) {
            return new RegisteredServiceImpl();
        }
        long serviceId = Long.parseLong(id);
        return this.servicesManager.findServiceBy(serviceId);
    }

    protected final Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("availableAttributes", this.personAttributeDao.getPossibleUserAttributeNames());
        model.put("pageTitle", this.getFormView());
        model.put("commandName", this.getCommandName());
        return model;
    }
}

