/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.StubPersonAttributeDao;

public abstract class AbstractPersonDirectoryCredentialsToPrincipalResolver
implements CredentialsToPrincipalResolver {
    protected final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private IPersonAttributeDao attributeRepository = new StubPersonAttributeDao();

    public final Principal resolvePrincipal(Credentials credentials) {
        String principalId;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Attempting to resolve a principal...");
        }
        if ((principalId = this.extractPrincipalId(credentials)) == null) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating SimplePrincipal for [" + principalId + "]"));
        }
        Map attributes = this.attributeRepository.getUserAttributes(principalId);
        return new SimplePrincipal(principalId, attributes);
    }

    protected abstract String extractPrincipalId(Credentials var1);

    public final void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }
}

