/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.audit.annotation.Auditable;
import org.inspektr.audit.spi.support.ObjectCreationAuditableActionResolver;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.audit.spi.CredentialsAsFirstParameterResourceResolver;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.NamedAuthenticationHandler;
import org.jasig.cas.authentication.handler.UnsupportedCredentialsException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationManagerImpl
implements AuthenticationManager {
    private final Log log = LogFactory.getLog(AuthenticationManagerImpl.class);
    @NotEmpty
    private List<AuthenticationHandler> authenticationHandlers;
    @NotEmpty
    private List<CredentialsToPrincipalResolver> credentialsToPrincipalResolvers;
    @NotNull
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();

    @Override
    @Auditable(action="AUTHENTICATION", successSuffix="_SUCCESS", failureSuffix="_FAILED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=CredentialsAsFirstParameterResourceResolver.class)
    public Authentication authenticate(Credentials credentials) throws AuthenticationException {
        boolean foundSupported = false;
        boolean authenticated = false;
        AuthenticationHandler authenticatedClass = null;
        for (AuthenticationHandler authenticationHandler : this.authenticationHandlers) {
            if (!authenticationHandler.supports(credentials)) continue;
            foundSupported = true;
            if (!authenticationHandler.authenticate(credentials)) {
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("AuthenticationHandler: " + authenticationHandler.getClass().getName() + " failed to authenticate the user which provided the following credentials: " + credentials.toString()));
                continue;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("AuthenticationHandler: " + authenticationHandler.getClass().getName() + " successfully authenticated the user which provided the following credentials: " + credentials.toString()));
            }
            authenticatedClass = authenticationHandler;
            authenticated = true;
            break;
        }
        if (!authenticated) {
            if (foundSupported) {
                throw BadCredentialsAuthenticationException.ERROR;
            }
            throw UnsupportedCredentialsException.ERROR;
        }
        Authentication authentication = null;
        foundSupported = false;
        for (CredentialsToPrincipalResolver credentialsToPrincipalResolver : this.credentialsToPrincipalResolvers) {
            if (!credentialsToPrincipalResolver.supports(credentials)) continue;
            Principal principal = credentialsToPrincipalResolver.resolvePrincipal(credentials);
            foundSupported = true;
            if (principal == null) continue;
            authentication = new MutableAuthentication(principal);
            break;
        }
        if (authentication == null) {
            if (foundSupported) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"CredentialsToPrincipalResolver found but no principal returned.");
                }
                throw BadCredentialsAuthenticationException.ERROR;
            }
            this.log.error((Object)("CredentialsToPrincipalResolver not found for " + credentials.getClass().getName()));
            throw UnsupportedCredentialsException.ERROR;
        }
        if (authenticatedClass instanceof NamedAuthenticationHandler) {
            NamedAuthenticationHandler a = (NamedAuthenticationHandler)authenticatedClass;
            authentication.getAttributes().put("authenticationMethod", a.getName());
        }
        for (AuthenticationMetaDataPopulator authenticationMetaDataPopulator : this.authenticationMetaDataPopulators) {
            authentication = authenticationMetaDataPopulator.populateAttributes(authentication, credentials);
        }
        return new ImmutableAuthentication(authentication.getPrincipal(), authentication.getAttributes());
    }

    public void setAuthenticationHandlers(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public void setCredentialsToPrincipalResolvers(List<CredentialsToPrincipalResolver> credentialsToPrincipalResolvers) {
        this.credentialsToPrincipalResolvers = credentialsToPrincipalResolvers;
    }

    public void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators) {
        this.authenticationMetaDataPopulators = authenticationMetaDataPopulators;
    }
}

