/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.dozer.util.mapping.classmap.AllowedExceptionContainer;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.classmap.CopyByReference;
import net.sf.dozer.util.mapping.classmap.CopyByReferenceContainer;
import net.sf.dozer.util.mapping.classmap.DozerClass;
import net.sf.dozer.util.mapping.classmap.Mappings;
import net.sf.dozer.util.mapping.converters.CustomConverterContainer;
import net.sf.dozer.util.mapping.converters.CustomConverterDescription;
import net.sf.dozer.util.mapping.fieldmap.CustomGetSetMethodFieldMap;
import net.sf.dozer.util.mapping.fieldmap.DozerField;
import net.sf.dozer.util.mapping.fieldmap.ExcludeFieldMap;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.fieldmap.GenericFieldMap;
import net.sf.dozer.util.mapping.fieldmap.HintContainer;
import net.sf.dozer.util.mapping.fieldmap.MapFieldMap;
import net.sf.dozer.util.mapping.util.DozerResolver;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final Log log = LogFactory.getLog((Class)XMLParser.class);
    private static final String WILDCARD = "wildcard";
    private static final String TRIM_STRINGS = "trim-strings";
    private static final String BEAN_FACTORY = "bean-factory";
    private static final String DATE_FORMAT = "date-format";
    private static final String RELATIONSHIP_TYPE = "relationship-type";
    private static final String REMOVE_ORPHANS = "remove-orphans";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String STOP_ON_ERRORS_ELEMENT = "stop-on-errors";
    private static final String CUSTOM_CONVERTERS_ELEMENT = "custom-converters";
    private static final String COPY_BY_REFERENCES_ELEMENT = "copy-by-references";
    private static final String COPY_BY_REFERENCE = "copy-by-reference";
    private static final String CONVERTER_ELEMENT = "converter";
    private static final String CLASS_A_ELEMENT = "class-a";
    private static final String CLASS_B_ELEMENT = "class-b";
    private static final String MAPPING_ELEMENT = "mapping";
    private static final String FIELD_ELEMENT = "field";
    private static final String FIELD_EXCLUDE_ELEMENT = "field-exclude";
    private static final String A_ELEMENT = "a";
    private static final String B_ELEMENT = "b";
    private static final String SRC_TYPE_HINT_ELEMENT = "a-hint";
    private static final String DEST_TYPE_HINT_ELEMENT = "b-hint";
    private static final String SRC_TYPE_DEEP_INDEX_HINT_ELEMENT = "a-deep-index-hint";
    private static final String DEST_TYPE_DEEP_INDEX_HINT_ELEMENT = "b-deep-index-hint";
    private static final String ALLOWED_EXCEPTIONS_ELEMENT = "allowed-exceptions";
    private static final String ALLOWED_EXCEPTION_ELEMENT = "exception";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String COPY_BY_REFERENCE_ATTRIBUTE = "copy-by-reference";
    private static final String THE_SET_METHOD_ATTRIBUTE = "set-method";
    private static final String THE_GET_METHOD_ATTRIBUTE = "get-method";
    private static final String STOP_ON_ERRORS_ATTRIBUTE = "stop-on-errors";
    private static final String MAPID_ATTRIBUTE = "map-id";
    private static final String MAP_SET_METHOD_ATTRIBUTE = "map-set-method";
    private static final String MAP_GET_METHOD_ATTRIBUTE = "map-get-method";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String FACTORY_BEANID_ATTRIBUTE = "factory-bean-id";
    private static final String IS_ACCESSIBLE_ATTRIBUTE = "is-accessible";
    private static final String CREATE_METHOD_ATTRIBUTE = "create-method";
    private static final String MAP_NULL_ATTRIBUTE = "map-null";
    private static final String MAP_EMPTY_STRING_ATTRIBUTE = "map-empty-string";
    private static final String CUSTOM_CONVERTER_ATTRIBUTE = "custom-converter";
    private static final String CUSTOM_CONVERTER_ID_ATTRIBUTE = "custom-converter-id";
    private final Mappings mappings = new Mappings();
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$net$sf$dozer$util$mapping$util$XMLParser$DozerDefaultHandler;

    public Mappings parse(InputStream inputSource) throws SAXException, ParserConfigurationException, IOException, ClassNotFoundException {
        DocumentBuilderFactory factory = this.createDocumentBuilderFactory();
        DocumentBuilder builder = this.createDocumentBuilder(factory);
        Document document = builder.parse(inputSource);
        Element theRoot = document.getDocumentElement();
        NodeList nl = theRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            log.debug((Object)("name: " + ele.getNodeName()));
            if (CONFIGURATION_ELEMENT.equals(ele.getNodeName())) {
                this.parseConfiguration(ele);
                continue;
            }
            if (!MAPPING_ELEMENT.equals(ele.getNodeName())) continue;
            this.parseMapping(ele);
        }
        return this.mappings;
    }

    private void parseMapping(Element ele) {
        ClassMap classMap = new ClassMap(this.mappings.getConfiguration());
        this.mappings.getMapping().add(classMap);
        if (StringUtils.isNotEmpty((String)ele.getAttribute(DATE_FORMAT))) {
            classMap.setDateFormat(ele.getAttribute(DATE_FORMAT));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(MAP_NULL_ATTRIBUTE))) {
            classMap.setMapNull(BooleanUtils.toBoolean((String)ele.getAttribute(MAP_NULL_ATTRIBUTE)));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(MAP_EMPTY_STRING_ATTRIBUTE))) {
            classMap.setMapEmptyString(BooleanUtils.toBoolean((String)ele.getAttribute(MAP_EMPTY_STRING_ATTRIBUTE)));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(BEAN_FACTORY))) {
            classMap.setBeanFactory(ele.getAttribute(BEAN_FACTORY));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(RELATIONSHIP_TYPE))) {
            classMap.setRelationshipType(ele.getAttribute(RELATIONSHIP_TYPE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(WILDCARD))) {
            classMap.setWildcard(Boolean.valueOf(ele.getAttribute(WILDCARD)));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(TRIM_STRINGS))) {
            classMap.setTrimStrings(Boolean.valueOf(ele.getAttribute(TRIM_STRINGS)));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute("stop-on-errors"))) {
            classMap.setStopOnErrors(Boolean.valueOf(ele.getAttribute("stop-on-errors")));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(MAPID_ATTRIBUTE))) {
            classMap.setMapId(ele.getAttribute(MAPID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(TYPE_ATTRIBUTE))) {
            classMap.setType(ele.getAttribute(TYPE_ATTRIBUTE));
        }
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            if (CLASS_A_ELEMENT.equals(element.getNodeName())) {
                DozerClass source = new DozerClass();
                source.setName(element.getFirstChild().getNodeValue().trim());
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_GET_METHOD_ATTRIBUTE))) {
                    source.setMapGetMethod(element.getAttribute(MAP_GET_METHOD_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_SET_METHOD_ATTRIBUTE))) {
                    source.setMapSetMethod(element.getAttribute(MAP_SET_METHOD_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(BEAN_FACTORY))) {
                    source.setBeanFactory(element.getAttribute(BEAN_FACTORY));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(FACTORY_BEANID_ATTRIBUTE))) {
                    source.setFactoryBeanId(element.getAttribute(FACTORY_BEANID_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(CREATE_METHOD_ATTRIBUTE))) {
                    source.setCreateMethod(element.getAttribute(CREATE_METHOD_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_NULL_ATTRIBUTE))) {
                    source.setMapNull(Boolean.valueOf(element.getAttribute(MAP_NULL_ATTRIBUTE)));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_EMPTY_STRING_ATTRIBUTE))) {
                    source.setMapEmptyString(Boolean.valueOf(element.getAttribute(MAP_EMPTY_STRING_ATTRIBUTE)));
                }
                classMap.setSrcClass(source);
            }
            if (CLASS_B_ELEMENT.equals(element.getNodeName())) {
                DozerClass dest = new DozerClass();
                dest.setName(element.getFirstChild().getNodeValue().trim());
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_GET_METHOD_ATTRIBUTE))) {
                    dest.setMapGetMethod(element.getAttribute(MAP_GET_METHOD_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_SET_METHOD_ATTRIBUTE))) {
                    dest.setMapSetMethod(element.getAttribute(MAP_SET_METHOD_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(BEAN_FACTORY))) {
                    dest.setBeanFactory(element.getAttribute(BEAN_FACTORY));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(FACTORY_BEANID_ATTRIBUTE))) {
                    dest.setFactoryBeanId(element.getAttribute(FACTORY_BEANID_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(CREATE_METHOD_ATTRIBUTE))) {
                    dest.setCreateMethod(element.getAttribute(CREATE_METHOD_ATTRIBUTE));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_NULL_ATTRIBUTE))) {
                    dest.setMapNull(Boolean.valueOf(element.getAttribute(MAP_NULL_ATTRIBUTE)));
                }
                if (StringUtils.isNotEmpty((String)element.getAttribute(MAP_EMPTY_STRING_ATTRIBUTE))) {
                    dest.setMapEmptyString(Boolean.valueOf(element.getAttribute(MAP_EMPTY_STRING_ATTRIBUTE)));
                }
                classMap.setDestClass(dest);
            }
            if (FIELD_ELEMENT.equals(element.getNodeName())) {
                this.parseGenericFieldMap(element, classMap);
                continue;
            }
            if (!FIELD_EXCLUDE_ELEMENT.equals(element.getNodeName())) continue;
            this.parseFieldExcludeMap(element, classMap);
        }
    }

    private void parseFieldExcludeMap(Element ele, ClassMap classMap) {
        ExcludeFieldMap efm = new ExcludeFieldMap(classMap);
        if (StringUtils.isNotEmpty((String)ele.getAttribute(TYPE_ATTRIBUTE))) {
            efm.setType(ele.getAttribute(TYPE_ATTRIBUTE));
        }
        classMap.addFieldMapping(efm);
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            this.parseFieldElements(element, efm);
        }
    }

    private void parseFieldElements(Element element, FieldMap fieldMap) {
        if (A_ELEMENT.equals(element.getNodeName())) {
            fieldMap.setSrcField(this.parseField(element));
        }
        if (B_ELEMENT.equals(element.getNodeName())) {
            fieldMap.setDestField(this.parseField(element));
        }
    }

    private void parseGenericFieldMap(Element ele, ClassMap classMap) {
        FieldMap fm = this.determineFieldMap(classMap, ele);
        classMap.addFieldMapping(fm);
        if (StringUtils.isNotEmpty((String)ele.getAttribute("copy-by-reference"))) {
            fm.setCopyByReference(BooleanUtils.toBoolean((String)ele.getAttribute("copy-by-reference")));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(MAPID_ATTRIBUTE))) {
            fm.setMapId(ele.getAttribute(MAPID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(TYPE_ATTRIBUTE))) {
            fm.setType(ele.getAttribute(TYPE_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(CUSTOM_CONVERTER_ATTRIBUTE))) {
            fm.setCustomConverter(ele.getAttribute(CUSTOM_CONVERTER_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(CUSTOM_CONVERTER_ID_ATTRIBUTE))) {
            fm.setCustomConverterId(ele.getAttribute(CUSTOM_CONVERTER_ID_ATTRIBUTE));
        }
        this.parseFieldMap(ele, fm);
    }

    private FieldMap determineFieldMap(ClassMap classMap, Element ele) {
        DozerField srcField = null;
        DozerField destField = null;
        FieldMap result = null;
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (A_ELEMENT.equals(element.getNodeName())) {
                srcField = this.parseField(element);
            }
            if (!B_ELEMENT.equals(element.getNodeName())) continue;
            destField = this.parseField(element);
        }
        result = srcField.isMapTypeCustomGetterSetterField() || destField.isMapTypeCustomGetterSetterField() || classMap.isSrcClassMapTypeCustomGetterSetter() || classMap.isDestClassMapTypeCustomGetterSetter() ? new MapFieldMap(classMap) : (srcField.isCustomGetterSetterField() || destField.isCustomGetterSetterField() ? new CustomGetSetMethodFieldMap(classMap) : new GenericFieldMap(classMap));
        return result;
    }

    private void parseFieldMap(Element ele, FieldMap fieldMap) {
        if (StringUtils.isNotEmpty((String)ele.getAttribute(RELATIONSHIP_TYPE))) {
            fieldMap.setRelationshipType(ele.getAttribute(RELATIONSHIP_TYPE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(REMOVE_ORPHANS))) {
            fieldMap.setRemoveOrphans(BooleanUtils.toBoolean((String)ele.getAttribute(REMOVE_ORPHANS)));
        }
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            HintContainer hintContainer;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            this.parseFieldElements(element, fieldMap);
            if (SRC_TYPE_HINT_ELEMENT.equals(element.getNodeName())) {
                hintContainer = new HintContainer();
                hintContainer.setHintName(element.getFirstChild().getNodeValue().trim());
                fieldMap.setSrcHintContainer(hintContainer);
            }
            if (DEST_TYPE_HINT_ELEMENT.equals(element.getNodeName())) {
                hintContainer = new HintContainer();
                hintContainer.setHintName(element.getFirstChild().getNodeValue().trim());
                fieldMap.setDestHintContainer(hintContainer);
            }
            if (SRC_TYPE_DEEP_INDEX_HINT_ELEMENT.equals(element.getNodeName())) {
                hintContainer = new HintContainer();
                hintContainer.setHintName(element.getFirstChild().getNodeValue().trim());
                fieldMap.setSrcDeepIndexHintContainer(hintContainer);
            }
            if (!DEST_TYPE_DEEP_INDEX_HINT_ELEMENT.equals(element.getNodeName())) continue;
            hintContainer = new HintContainer();
            hintContainer.setHintName(element.getFirstChild().getNodeValue().trim());
            fieldMap.setDestDeepIndexHintContainer(hintContainer);
        }
    }

    private boolean isIndexed(String fieldName) {
        return fieldName != null && fieldName.matches(".+\\[\\d+\\]");
    }

    private String getFieldNameOfIndexedField(String fieldName) {
        return fieldName == null ? null : fieldName.replaceAll("\\[\\d+\\]", "");
    }

    private int getIndexOfIndexedField(String fieldName) {
        return Integer.parseInt(fieldName.replaceAll(".*\\[", "").replaceAll("\\]", ""));
    }

    private DozerField parseField(Element ele) {
        DozerField rvalue = null;
        String type = null;
        String name = ele.getFirstChild().getNodeValue().trim();
        String fieldName = this.isIndexed(name) ? this.getFieldNameOfIndexedField(name) : name;
        if (StringUtils.isNotEmpty((String)ele.getAttribute(TYPE_ATTRIBUTE))) {
            type = ele.getAttribute(TYPE_ATTRIBUTE);
        }
        rvalue = new DozerField(fieldName, type);
        if (this.isIndexed(name)) {
            rvalue.setIndexed(true);
            rvalue.setIndex(this.getIndexOfIndexedField(name));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(DATE_FORMAT))) {
            rvalue.setDateFormat(ele.getAttribute(DATE_FORMAT));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(THE_GET_METHOD_ATTRIBUTE))) {
            rvalue.setTheGetMethod(ele.getAttribute(THE_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(THE_SET_METHOD_ATTRIBUTE))) {
            rvalue.setTheSetMethod(ele.getAttribute(THE_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(MAP_GET_METHOD_ATTRIBUTE))) {
            rvalue.setMapGetMethod(ele.getAttribute(MAP_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(MAP_SET_METHOD_ATTRIBUTE))) {
            rvalue.setMapSetMethod(ele.getAttribute(MAP_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(KEY_ATTRIBUTE))) {
            rvalue.setKey(ele.getAttribute(KEY_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(CREATE_METHOD_ATTRIBUTE))) {
            rvalue.setCreateMethod(ele.getAttribute(CREATE_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)ele.getAttribute(IS_ACCESSIBLE_ATTRIBUTE))) {
            rvalue.setAccessible(BooleanUtils.toBoolean((String)ele.getAttribute(IS_ACCESSIBLE_ATTRIBUTE)));
        }
        return rvalue;
    }

    private void parseConfiguration(Element ele) {
        Configuration config = new Configuration();
        this.mappings.setConfiguration(config);
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            if ("stop-on-errors".equals(element.getNodeName())) {
                config.setStopOnErrors(Boolean.valueOf(element.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (DATE_FORMAT.equals(element.getNodeName())) {
                config.setDateFormat(element.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (WILDCARD.equals(element.getNodeName())) {
                config.setWildcard(Boolean.valueOf(element.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (TRIM_STRINGS.equals(element.getNodeName())) {
                config.setTrimStrings(Boolean.valueOf(element.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (RELATIONSHIP_TYPE.equals(element.getNodeName())) {
                config.setRelationshipType(element.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (BEAN_FACTORY.equals(element.getNodeName())) {
                config.setBeanFactory(element.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (CUSTOM_CONVERTERS_ELEMENT.equals(element.getNodeName())) {
                this.parseCustomConverters(element, config);
                continue;
            }
            if (COPY_BY_REFERENCES_ELEMENT.equals(element.getNodeName())) {
                this.parseCopyByReferences(element, config);
                continue;
            }
            if (!ALLOWED_EXCEPTIONS_ELEMENT.equals(element.getNodeName())) continue;
            this.parseAllowedExceptions(element, config);
        }
    }

    private void parseCustomConverters(Element ele, Configuration config) {
        CustomConverterContainer container = new CustomConverterContainer();
        config.setCustomConverters(container);
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            if (!CONVERTER_ELEMENT.equals(element.getNodeName())) continue;
            CustomConverterDescription customConverter = new CustomConverterDescription();
            container.addConverter(customConverter);
            customConverter.setType(MappingUtils.loadClass(element.getAttribute(TYPE_ATTRIBUTE)));
            NodeList list = element.getChildNodes();
            for (int x = 0; x < list.getLength(); ++x) {
                Node node1 = list.item(x);
                if (!(node1 instanceof Element)) continue;
                Element element1 = (Element)node1;
                if (CLASS_A_ELEMENT.equals(element1.getNodeName())) {
                    customConverter.setClassA(MappingUtils.loadClass(element1.getFirstChild().getNodeValue().trim()));
                    continue;
                }
                if (!CLASS_B_ELEMENT.equals(element1.getNodeName())) continue;
                customConverter.setClassB(MappingUtils.loadClass(element1.getFirstChild().getNodeValue().trim()));
            }
        }
    }

    private void parseCopyByReferences(Element ele, Configuration config) {
        CopyByReferenceContainer container = new CopyByReferenceContainer();
        config.setCopyByReferences(container);
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            if (!"copy-by-reference".equals(element.getNodeName())) continue;
            CopyByReference cbr = new CopyByReference();
            container.getCopyByReferences().add(cbr);
            cbr.setReferenceName(element.getFirstChild().getNodeValue().trim());
        }
    }

    private void parseAllowedExceptions(Element ele, Configuration config) {
        AllowedExceptionContainer container = new AllowedExceptionContainer();
        config.setAllowedExceptions(container);
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Class ex;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
            if (!ALLOWED_EXCEPTION_ELEMENT.equals(element.getNodeName())) continue;
            if (!(class$java$lang$RuntimeException == null ? XMLParser.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(ex = MappingUtils.loadClass(element.getFirstChild().getNodeValue()))) {
                MappingUtils.throwMappingException("allowed-exception Class must extend RuntimeException: " + element.getFirstChild().getNodeValue());
            }
            container.getExceptions().add(ex);
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        factory.setIgnoringElementContentWhitespace(true);
        return factory;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setErrorHandler(new DozerDefaultHandler());
        docBuilder.setEntityResolver(new DozerResolver());
        return docBuilder;
    }

    class DozerDefaultHandler
    extends DefaultHandler {
        private final Log log = LogFactory.getLog((Class)(class$net$sf$dozer$util$mapping$util$XMLParser$DozerDefaultHandler == null ? (class$net$sf$dozer$util$mapping$util$XMLParser$DozerDefaultHandler = XMLParser.class$("net.sf.dozer.util.mapping.util.XMLParser$DozerDefaultHandler")) : class$net$sf$dozer$util$mapping$util$XMLParser$DozerDefaultHandler));

        DozerDefaultHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.log.debug((Object)("tag: " + qName));
        }

        public void warning(SAXParseException e) throws SAXException {
            throw new SAXException(this.getMessage("Warning", e));
        }

        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(this.getMessage("Error", e));
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(this.getMessage("Fatal Error", e));
        }

        private String getMessage(String level, SAXParseException e) {
            return "Parsing " + level + "\n" + "Line:    " + e.getLineNumber() + "\n" + "URI:     " + e.getSystemId() + "\n" + "Message: " + e.getMessage();
        }
    }
}

