/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.config.GlobalSettings;
import net.sf.dozer.util.mapping.fieldmap.HintContainer;
import net.sf.dozer.util.mapping.util.DeepHierarchyElement;
import net.sf.dozer.util.mapping.util.Jdk5Methods;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class ReflectionUtils {
    static /* synthetic */ Class class$java$util$Collection;

    public static PropertyDescriptor findPropertyDescriptor(Class objectClass, String fieldName, HintContainer deepIndexHintContainer) {
        PropertyDescriptor result = null;
        if (fieldName.indexOf(".") >= 0) {
            DeepHierarchyElement[] hierarchy = ReflectionUtils.getDeepFieldHierarchy(objectClass, fieldName, deepIndexHintContainer);
            result = hierarchy[hierarchy.length - 1].getPropDescriptor();
        } else {
            PropertyDescriptor[] descriptors = ReflectionUtils.getPropertyDescriptors(objectClass);
            if (descriptors != null) {
                int size = descriptors.length;
                for (int i = 0; i < size; ++i) {
                    if (!fieldName.equalsIgnoreCase(descriptors[i].getName())) continue;
                    result = descriptors[i];
                    break;
                }
            }
        }
        return result;
    }

    public static DeepHierarchyElement[] getDeepFieldHierarchy(Class parentClass, String field, HintContainer deepIndexHintContainer) {
        if (field.indexOf(".") < 0) {
            MappingUtils.throwMappingException("Field does not contain deep field delimitor");
        }
        StringTokenizer toks = new StringTokenizer(field, ".");
        Class latestClass = parentClass;
        DeepHierarchyElement[] hierarchy = new DeepHierarchyElement[toks.countTokens()];
        int index = 0;
        int hintIndex = 0;
        while (toks.hasMoreTokens()) {
            String aFieldName;
            String theFieldName = aFieldName = toks.nextToken();
            int collectionIndex = -1;
            if (aFieldName.indexOf("[") > 0) {
                theFieldName = aFieldName.substring(0, aFieldName.indexOf("["));
                collectionIndex = Integer.parseInt(aFieldName.substring(aFieldName.indexOf("[") + 1, aFieldName.indexOf("]")));
            }
            PropertyDescriptor propDescriptor = ReflectionUtils.findPropertyDescriptor(latestClass, theFieldName, deepIndexHintContainer);
            DeepHierarchyElement r = new DeepHierarchyElement(propDescriptor, collectionIndex);
            if (propDescriptor == null) {
                MappingUtils.throwMappingException("Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
            }
            latestClass = propDescriptor.getPropertyType();
            if (toks.hasMoreTokens()) {
                if (latestClass.isArray()) {
                    latestClass = latestClass.getComponentType();
                } else if ((class$java$util$Collection == null ? ReflectionUtils.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(latestClass)) {
                    Class genericType = ReflectionUtils.determineGenericsType(propDescriptor);
                    if (genericType == null && deepIndexHintContainer == null) {
                        MappingUtils.throwMappingException("Hint(s) or Generics not specified.  Hint(s) or Generics must be specified for deep mapping with indexed field(s). Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
                    }
                    if (genericType != null) {
                        latestClass = genericType;
                    } else {
                        latestClass = deepIndexHintContainer.getHint(hintIndex);
                        ++hintIndex;
                    }
                }
            }
            hierarchy[index++] = r;
        }
        return hierarchy;
    }

    public static Method getMethod(Object obj, String methodName) {
        return ReflectionUtils.getMethod(obj.getClass(), methodName);
    }

    public static Method getMethod(Class clazz, String methodName) {
        Method result = ReflectionUtils.findMethod(clazz, methodName);
        if (result == null) {
            MappingUtils.throwMappingException("No method found for class:" + clazz + " and method name:" + methodName);
        }
        return result;
    }

    private static Method findMethod(Class clazz, String methodName) {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName)) continue;
            result = method;
        }
        return result;
    }

    public static Method findAMethod(Class parentDestClass, String methodName) throws NoSuchMethodException {
        StringTokenizer tokenizer = new StringTokenizer(methodName, "(");
        String m = tokenizer.nextToken();
        if (tokenizer.hasMoreElements()) {
            StringTokenizer tokens = new StringTokenizer(tokenizer.nextToken(), ")");
            String params = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            return ReflectionUtils.findMethodWithParam(parentDestClass, m, params);
        }
        return ReflectionUtils.findMethod(parentDestClass, methodName);
    }

    private static Method findMethodWithParam(Class parentDestClass, String methodName, String params) throws NoSuchMethodException {
        ArrayList<Class> list = new ArrayList<Class>();
        if (params != null) {
            StringTokenizer tokenizer = new StringTokenizer(params, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                list.add(MappingUtils.loadClass(token));
            }
        }
        return ReflectionUtils.getMethod(parentDestClass, methodName, list.toArray(new Class[list.size()]));
    }

    protected static PropertyDescriptor[] getPropertyDescriptors(Class objectClass) {
        if (objectClass.isInterface()) {
            return ReflectionUtils.getInterfacePropertyDescriptors(objectClass);
        }
        return PropertyUtils.getPropertyDescriptors((Class)objectClass);
    }

    private static PropertyDescriptor[] getInterfacePropertyDescriptors(Class interfaceClass) {
        ArrayList<PropertyDescriptor> propDescriptors = new ArrayList<PropertyDescriptor>();
        propDescriptors.addAll(Arrays.asList(PropertyUtils.getPropertyDescriptors((Class)interfaceClass)));
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> superInterfaceClass = interfaces[i];
                List<PropertyDescriptor> superInterfacePropertyDescriptors = Arrays.asList(ReflectionUtils.getInterfacePropertyDescriptors(superInterfaceClass));
                boolean j = false;
                while (i < superInterfacePropertyDescriptors.size()) {
                    PropertyDescriptor superPropDescriptor = superInterfacePropertyDescriptors.get(i);
                    PropertyDescriptor existingPropDescriptor = ReflectionUtils.findPropDescriptorByName(propDescriptors, superPropDescriptor.getName());
                    if (existingPropDescriptor == null) {
                        propDescriptors.add(superPropDescriptor);
                    } else {
                        try {
                            if (existingPropDescriptor.getReadMethod() == null) {
                                existingPropDescriptor.setReadMethod(superPropDescriptor.getReadMethod());
                            }
                            if (existingPropDescriptor.getWriteMethod() == null) {
                                existingPropDescriptor.setWriteMethod(superPropDescriptor.getWriteMethod());
                            }
                        }
                        catch (IntrospectionException e) {
                            throw new MappingException(e);
                        }
                    }
                    ++i;
                }
            }
        }
        return propDescriptors.toArray(new PropertyDescriptor[propDescriptors.size()]);
    }

    private static PropertyDescriptor findPropDescriptorByName(List propDescriptors, String name) {
        PropertyDescriptor result = null;
        Iterator iter = propDescriptors.iterator();
        while (iter.hasNext()) {
            PropertyDescriptor entry = (PropertyDescriptor)iter.next();
            if (!entry.getName().equals(name)) continue;
            result = entry;
            break;
        }
        return result;
    }

    public static Field getFieldFromBean(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtils.getFieldFromBean(clazz.getSuperclass(), fieldName);
            }
            throw e;
        }
    }

    public static Object invoke(Method method, Object obj, Object[] args) {
        Object result = null;
        try {
            result = method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (InvocationTargetException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public static Method getMethod(Class clazz, String name, Class[] parameterTypes) throws NoSuchMethodException {
        return clazz.getMethod(name, parameterTypes);
    }

    public static Object newInstance(Class clazz) {
        Object result = null;
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public static Class determineGenericsType(PropertyDescriptor propDescriptor) {
        if (!GlobalSettings.getInstance().isJava5()) {
            return null;
        }
        Class result = null;
        if (propDescriptor.getWriteMethod() != null) {
            result = ReflectionUtils.determineGenericsType(propDescriptor.getWriteMethod(), false);
        }
        if (result == null && propDescriptor.getReadMethod() != null) {
            result = ReflectionUtils.determineGenericsType(propDescriptor.getReadMethod(), true);
        }
        return result;
    }

    public static Class determineGenericsType(Method method, boolean isReadMethod) {
        if (!GlobalSettings.getInstance().isJava5()) {
            return null;
        }
        Class result = null;
        Class parameterTypesClass = Jdk5Methods.getInstance().getParameterizedTypeClass();
        if (isReadMethod) {
            Object genericType;
            Object parameterType = ReflectionUtils.invoke(Jdk5Methods.getInstance().getMethodGetGenericReturnTypeMethod(), method, null);
            if (parameterType != null && parameterTypesClass.isAssignableFrom(parameterType.getClass()) && (genericType = ((Object[])ReflectionUtils.invoke(Jdk5Methods.getInstance().getParamaterizedTypeGetActualTypeArgsMethod(), parameterType, null))[0]) != null) {
                result = (Class)genericType;
            }
        } else {
            Object genericType;
            Object[] parameterTypes = (Object[])ReflectionUtils.invoke(Jdk5Methods.getInstance().getMethodGetGenericParameterTypesMethod(), method, null);
            if (parameterTypes != null && parameterTypesClass.isAssignableFrom(parameterTypes[0].getClass()) && (genericType = ((Object[])ReflectionUtils.invoke(Jdk5Methods.getInstance().getParamaterizedTypeGetActualTypeArgsMethod(), parameterTypes[0], null))[0]) != null) {
                result = (Class)genericType;
            }
        }
        return result;
    }
}

