/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.ResourceLoader;

public abstract class MappingValidator {
    public static void validateMappingRequest(Object srcObj) {
        if (srcObj == null) {
            MappingUtils.throwMappingException("source object must not be null");
        }
    }

    public static void validateMappingRequest(Object srcObj, Object destObj) {
        if (srcObj == null) {
            MappingUtils.throwMappingException("source object must not be null");
        }
        if (destObj == null) {
            MappingUtils.throwMappingException("destination object must not be null");
        }
    }

    public static void validateMappingRequest(Object srcObj, Class destClass) {
        if (srcObj == null) {
            MappingUtils.throwMappingException("source object must not be null");
        }
        if (destClass == null) {
            MappingUtils.throwMappingException("destination class must not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URL validateURL(String fileName) {
        ResourceLoader loader = new ResourceLoader();
        URL url = loader.getResource(fileName);
        if (url == null) {
            MappingUtils.throwMappingException("Unable to locate dozer mapping file [" + fileName + "] in the classpath!!!");
        }
        InputStream stream = null;
        stream = url.openStream();
        Object var6_4 = null;
        if (stream == null) return url;
        try {
            stream.close();
            return url;
        }
        catch (IOException e2) {
            MappingUtils.throwMappingException("Unable to close input stream for dozer mapping file [" + url + "]");
        }
        return url;
        {
            catch (IOException e) {
                MappingUtils.throwMappingException("Unable to open URL input stream for dozer mapping file [" + url + "]");
                Object var6_5 = null;
                if (stream == null) return url;
                try {
                    stream.close();
                    return url;
                }
                catch (IOException e2) {
                    MappingUtils.throwMappingException("Unable to close input stream for dozer mapping file [" + url + "]");
                }
                return url;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e2) {
                MappingUtils.throwMappingException("Unable to close input stream for dozer mapping file [" + url + "]");
            }
            throw throwable;
        }
    }
}

