/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.cache.Cache;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.classmap.CopyByReference;
import net.sf.dozer.util.mapping.classmap.DozerClass;
import net.sf.dozer.util.mapping.converters.CustomConverterContainer;
import net.sf.dozer.util.mapping.fieldmap.DozerField;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class MappingUtils {
    public static final Map storedFactories = Collections.synchronizedMap(new HashMap());

    public static String getClassNameWithoutPackage(Class clazz) {
        Package pckage = clazz.getPackage();
        int pckageIndex = 0;
        if (pckage != null) {
            pckageIndex = pckage.getName().length() + 1;
        }
        return clazz.getName().substring(pckageIndex);
    }

    public static boolean isSupportedCollection(Class aClass) {
        boolean result = false;
        if (CollectionUtils.isCollection(aClass)) {
            result = true;
        } else if (CollectionUtils.isArray(aClass)) {
            result = true;
        }
        return result;
    }

    public static boolean isSupportedMap(Class aClass) {
        return Map.class.isAssignableFrom(aClass);
    }

    public static boolean isPrimitiveOrWrapper(Class aClass) {
        return aClass.isPrimitive() || Number.class.isAssignableFrom(aClass) || aClass.equals(String.class) || aClass.equals(Character.class) || aClass.equals(Boolean.class) || Date.class.isAssignableFrom(aClass) || Calendar.class.isAssignableFrom(aClass);
    }

    public static void throwMappingException(Throwable e) throws MappingException {
        if (e instanceof MappingException) {
            throw (MappingException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new MappingException(e);
    }

    public static void throwMappingException(String msg) throws MappingException {
        throw new MappingException(msg);
    }

    public static void throwMappingException(String msg, Throwable cause) throws MappingException {
        throw new MappingException(msg, cause);
    }

    public static boolean isBlankOrNull(String value) {
        return value == null || value.trim().length() < 1;
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable rootCause = ex;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    public static String getMappedParentFieldKey(Object destObj, String destFieldName) {
        StringBuffer buf = new StringBuffer(150);
        buf.append(System.identityHashCode(destObj));
        buf.append(destFieldName);
        return buf.toString();
    }

    public static Class findCustomConverter(Cache converterByDestTypeCache, CustomConverterContainer customConverterContainer, Class srcClass, Class destClass) {
        if (customConverterContainer == null || customConverterContainer.getConverters() == null || customConverterContainer.getConverters().size() < 1) {
            return null;
        }
        return customConverterContainer.getCustomConverter(srcClass, destClass, converterByDestTypeCache);
    }

    public static Class determineCustomConverter(FieldMap fieldMap, Cache converterByDestTypeCache, CustomConverterContainer customConverterContainer, Class srcClass, Class destClass) {
        if (customConverterContainer == null || customConverterContainer.getConverters() == null || customConverterContainer.getConverters().size() < 1) {
            return null;
        }
        if (fieldMap != null && fieldMap.isDestFieldIndexed()) {
            if (destClass.isArray()) {
                destClass = destClass.getComponentType();
            } else if (destClass.isAssignableFrom(Collection.class) && fieldMap.getDestHintContainer() != null && !fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destClass = fieldMap.getDestHintContainer().getHint();
            }
        }
        return MappingUtils.findCustomConverter(converterByDestTypeCache, customConverterContainer, srcClass, destClass);
    }

    public static void reverseFields(FieldMap source, FieldMap destination) {
        DozerField df = new DozerField(source.getSrcFieldName(), source.getSrcFieldType());
        df.setIndexed(source.isSrcFieldIndexed());
        df.setIndex(source.getSrcFieldIndex());
        df.setDateFormat(source.getSrcFieldDateFormat());
        df.setTheGetMethod(source.getSrcFieldTheGetMethod());
        df.setTheSetMethod(source.getSrcFieldTheSetMethod());
        df.setKey(source.getSrcFieldKey());
        df.setMapGetMethod(source.getSrcFieldMapGetMethod());
        df.setMapSetMethod(source.getSrcFieldMapSetMethod());
        df.setCreateMethod(source.getSrcFieldCreateMethod());
        df.setAccessible(source.isSrcFieldAccessible());
        DozerField sf = new DozerField(source.getDestFieldName(), source.getDestFieldType());
        sf.setIndexed(source.isDestFieldIndexed());
        sf.setIndex(source.getDestFieldIndex());
        sf.setDateFormat(source.getDestFieldDateFormat());
        sf.setTheGetMethod(source.getDestFieldTheGetMethod());
        sf.setTheSetMethod(source.getDestFieldTheSetMethod());
        sf.setKey(source.getDestFieldKey());
        sf.setMapGetMethod(source.getDestFieldMapGetMethod());
        sf.setMapSetMethod(source.getDestFieldMapSetMethod());
        sf.setCreateMethod(source.getDestFieldCreateMethod());
        sf.setAccessible(source.isDestFieldAccessible());
        destination.setDestField(df);
        destination.setSrcField(sf);
        destination.setCustomConverter(source.getCustomConverter());
        destination.setCustomConverterId(source.getCustomConverterId());
        destination.setMapId(source.getMapId());
        destination.setRelationshipType(source.getRelationshipType());
        destination.setRemoveOrphans(source.isRemoveOrphans());
        destination.setSrcHintContainer(source.getDestHintContainer());
        destination.setDestHintContainer(source.getSrcHintContainer());
        destination.setSrcDeepIndexHintContainer(source.getDestDeepIndexHintContainer());
        destination.setDestDeepIndexHintContainer(source.getSrcDeepIndexHintContainer());
    }

    public static void reverseFields(ClassMap source, ClassMap destination) {
        destination.setSrcClass(new DozerClass(source.getDestClassName(), source.getDestClassToMap(), source.getDestClassBeanFactory(), source.getDestClassBeanFactoryId(), source.getDestClassMapGetMethod(), source.getDestClassMapSetMethod(), source.isDestMapNull(), source.isDestMapEmptyString()));
        destination.setDestClass(new DozerClass(source.getSrcClassName(), source.getSrcClassToMap(), source.getSrcClassBeanFactory(), source.getSrcClassBeanFactoryId(), source.getSrcClassMapGetMethod(), source.getSrcClassMapSetMethod(), source.isSrcMapNull(), source.isSrcMapEmptyString()));
        destination.setType(source.getType());
        destination.setWildcard(source.isWildcard());
        destination.setTrimStrings(source.isTrimStrings());
        destination.setDateFormat(source.getDateFormat());
        destination.setRelationshipType(source.getRelationshipType());
        destination.setStopOnErrors(source.isStopOnErrors());
        destination.setAllowedExceptions(source.getAllowedExceptions());
        destination.setSrcClassCreateMethod(source.getDestClassCreateMethod());
        destination.setDestClassCreateMethod(source.getSrcClassCreateMethod());
        if (StringUtils.isNotEmpty((String)source.getMapId())) {
            destination.setMapId(source.getMapId());
        }
    }

    public static Object getIndexedValue(Object collection, int index) {
        Collection x;
        Object result = null;
        if (collection instanceof Object[]) {
            Object[] x2 = (Object[])collection;
            if (index < x2.length) {
                return x2[index];
            }
        } else if (collection instanceof Collection && index < (x = (Collection)collection).size()) {
            Iterator iter = x.iterator();
            for (int i = 0; i < index; ++i) {
                iter.next();
            }
            result = iter.next();
        }
        return result;
    }

    public static void applyGlobalCopyByReference(Configuration globalConfig, FieldMap fieldMap, ClassMap classMap) {
        String destFieldTypeName = null;
        if (globalConfig.getCopyByReferences() != null) {
            Iterator copyIterator = globalConfig.getCopyByReferences().getCopyByReferences().iterator();
            Class clazz = fieldMap.getDestFieldType(classMap.getDestClassToMap());
            if (clazz != null) {
                destFieldTypeName = clazz.getName();
            }
            while (copyIterator.hasNext()) {
                CopyByReference copyByReference = (CopyByReference)copyIterator.next();
                if (!copyByReference.getReferenceName().equals(destFieldTypeName) || fieldMap.isCopyByReferenceOveridden()) continue;
                fieldMap.setCopyByReference(true);
            }
        }
    }

    public static Class loadClass(String name) {
        Class<?> result = null;
        try {
            result = Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public static boolean isProxy(Class clazz) {
        return clazz.getName().indexOf("$$EnhancerByCGLIB$$") >= 0;
    }

    public static Class getRealSuperclass(Class clazz) {
        return clazz.getName().indexOf("$$EnhancerByCGLIB$$") >= 0 ? clazz.getSuperclass().getSuperclass() : clazz.getSuperclass();
    }

    public static Class getProxyRealClass(Class clazz) {
        if (!MappingUtils.isProxy(clazz)) {
            throw new IllegalArgumentException("specified class is not a proxy: " + clazz);
        }
        return clazz.getSuperclass();
    }

    public static Object prepareIndexedCollection(Class collectionType, Object existingCollection, Object collectionEntry, int index) {
        Object[] result = null;
        if (existingCollection == null) {
            existingCollection = collectionType.isArray() ? Array.newInstance(collectionType.getComponentType(), 0) : (CollectionUtils.isSet(collectionType) ? new HashSet() : new ArrayList());
        }
        if (existingCollection instanceof Collection) {
            AbstractCollection newCollection = existingCollection instanceof Set ? new HashSet() : new ArrayList();
            Collection c = (Collection)existingCollection;
            Iterator i = c.iterator();
            int x = 0;
            while (i.hasNext()) {
                if (x != index) {
                    newCollection.add(i.next());
                } else {
                    newCollection.add(collectionEntry);
                }
                ++x;
            }
            if (newCollection.size() <= index) {
                while (newCollection.size() < index) {
                    newCollection.add(null);
                }
                newCollection.add(collectionEntry);
            }
            result = newCollection;
        } else if (existingCollection.getClass().isArray()) {
            Object[] objs = (Object[])existingCollection;
            Object[] x = (Object[])Array.newInstance(objs.getClass().getComponentType(), objs.length > index ? objs.length + 1 : index + 1);
            for (int i = 0; i < objs.length; ++i) {
                x[i] = objs[i];
            }
            x[index] = collectionEntry;
            result = x;
        }
        return result;
    }
}

