/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.lang.reflect.Method;
import net.sf.dozer.util.mapping.util.MappingUtils;

public class Jdk5Methods {
    private static Jdk5Methods singleton;
    private Method classIsEnumMethod;
    private Method enumNameMethod;
    private Method enumValueOfMethod;
    private Method methodGetGenericParameterTypesMethod;
    private Method methodGetGenericReturnTypeMethod;
    private Class parameterizedTypeClass;
    private Method paramaterizedTypeGetActualTypeArgsMethod;

    public static Jdk5Methods getInstance() {
        if (singleton == null) {
            singleton = new Jdk5Methods();
        }
        return singleton;
    }

    private Jdk5Methods() {
        this.init();
    }

    private synchronized void init() {
        try {
            this.classIsEnumMethod = Class.class.getMethod("isEnum", null);
            Class<?> enumClass = Class.forName("java.lang.Enum");
            this.enumNameMethod = enumClass.getMethod("name", null);
            this.enumValueOfMethod = enumClass.getMethod("valueOf", Class.class, String.class);
            this.methodGetGenericParameterTypesMethod = Method.class.getMethod("getGenericParameterTypes", null);
            this.methodGetGenericReturnTypeMethod = Method.class.getMethod("getGenericReturnType", null);
            this.parameterizedTypeClass = Class.forName("java.lang.reflect.ParameterizedType");
            this.paramaterizedTypeGetActualTypeArgsMethod = this.parameterizedTypeClass.getMethod("getActualTypeArguments", null);
        }
        catch (Exception e) {
            MappingUtils.throwMappingException("Unable to load jdk 1.5 classes via relection", e);
        }
    }

    public Method getClassIsEnumMethod() {
        return this.classIsEnumMethod;
    }

    public Method getEnumNameMethod() {
        return this.enumNameMethod;
    }

    public Method getEnumValueOfMethod() {
        return this.enumValueOfMethod;
    }

    public Method getMethodGetGenericParameterTypesMethod() {
        return this.methodGetGenericParameterTypesMethod;
    }

    public Method getMethodGetGenericReturnTypeMethod() {
        return this.methodGetGenericReturnTypeMethod;
    }

    public Method getParamaterizedTypeGetActualTypeArgsMethod() {
        return this.paramaterizedTypeGetActualTypeArgsMethod;
    }

    public Class getParameterizedTypeClass() {
        return this.parameterizedTypeClass;
    }
}

