/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DozerResolver
implements EntityResolver {
    private static final Log log = LogFactory.getLog((Class)DozerResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) {
        log.debug((Object)("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]"));
        if (systemId != null && systemId.indexOf("dozerbeanmapping.dtd") > systemId.lastIndexOf("/")) {
            String dtdFile = systemId.substring(systemId.indexOf("dozerbeanmapping.dtd"));
            log.debug((Object)("Trying to locate [" + dtdFile + "] in classpath"));
            try {
                InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(dtdFile);
                InputSource source = new InputSource(stream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                log.debug((Object)("Found dozerbeanmapping DTD [" + systemId + "] in classpath"));
                return source;
            }
            catch (Exception ex) {
                log.error((Object)("Could not resolve beans DTD [" + systemId + "]: not found in classpath"), (Throwable)ex);
            }
        }
        return null;
    }
}

