/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.sf.dozer.util.mapping.BeanFactoryIF;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DestBeanCreator {
    private static final Log log = LogFactory.getLog((Class)DestBeanCreator.class);

    public static Object create(Class targetClass) {
        return DestBeanCreator.create(targetClass, null);
    }

    public static Object create(Class targetClass, Class alternateClass) {
        return DestBeanCreator.create(null, null, targetClass, alternateClass, null, null, null);
    }

    public static Object create(Object srcObject, Class srcClass, Class targetClass, Class alternateClass, String factoryName, String factoryId, String createMethod) {
        Object rvalue;
        block15: {
            Class classToCreate;
            Class clazz = classToCreate = targetClass != null ? targetClass : alternateClass;
            if (!MappingUtils.isBlankOrNull(createMethod)) {
                Method method = null;
                try {
                    method = ReflectionUtils.getMethod(classToCreate, createMethod, null);
                }
                catch (NoSuchMethodException e) {
                    MappingUtils.throwMappingException(e);
                }
                return ReflectionUtils.invoke(method, null, null);
            }
            if (!MappingUtils.isBlankOrNull(factoryName)) {
                Object factoryCreatedObj = DestBeanCreator.createFromFactory(srcObject, srcClass, classToCreate, factoryName, factoryId);
                if (!classToCreate.isAssignableFrom(factoryCreatedObj.getClass())) {
                    MappingUtils.throwMappingException("Custom bean factory did not return correct type of destination data object.  Expected: " + classToCreate + ", Actual: " + factoryCreatedObj.getClass());
                }
                return factoryCreatedObj;
            }
            rvalue = null;
            if (MappingUtils.isSupportedMap(classToCreate)) {
                rvalue = new HashMap();
            } else {
                try {
                    rvalue = DestBeanCreator.newInstance(classToCreate);
                }
                catch (Exception e) {
                    if (alternateClass != null) {
                        try {
                            rvalue = DestBeanCreator.newInstance(alternateClass);
                        }
                        catch (MappingException me) {
                            if (me.getCause() instanceof NoSuchMethodException) {
                                try {
                                    rvalue = DestBeanCreator.createFromFactory(srcObject, srcClass, classToCreate, "net.sf.dozer.util.mapping.factory.XMLBeanFactory", factoryId);
                                    break block15;
                                }
                                catch (MappingException e1) {
                                    log.error((Object)"Error trying to use XMLBeanFactory.", (Throwable)e1);
                                    throw me;
                                }
                            }
                            throw me;
                        }
                    }
                    MappingUtils.throwMappingException(e);
                }
            }
        }
        return rvalue;
    }

    private static Object createFromFactory(Object srcObject, Class srcObjectClass, Class destClass, String factoryName, String factoryBeanId) {
        String beanId = !MappingUtils.isBlankOrNull(factoryBeanId) ? factoryBeanId : destClass.getName();
        BeanFactoryIF factory = (BeanFactoryIF)MappingUtils.storedFactories.get(factoryName);
        if (factory == null) {
            Class factoryClass;
            if (!BeanFactoryIF.class.isAssignableFrom(factoryClass = MappingUtils.loadClass(factoryName))) {
                MappingUtils.throwMappingException("Custom bean factory must implement the BeanFactoryIF interface.");
            }
            factory = (BeanFactoryIF)DestBeanCreator.newInstance(factoryClass);
            MappingUtils.storedFactories.put(factoryName, factory);
        }
        Object rvalue = factory.createBean(srcObject, srcObjectClass, beanId);
        log.debug((Object)("Bean instance created with custom factory -->\n  Bean Type: " + rvalue.getClass().getName() + "\n  Factory Name: " + factoryName));
        return rvalue;
    }

    private static Object newInstance(Class clazz) {
        Constructor constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(null);
        }
        catch (SecurityException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        if (constructor == null) {
            MappingUtils.throwMappingException("Could not create a new instance of the dest object: " + clazz + ".  Could not find a no-arg constructor for this class.");
        }
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        Object result = null;
        try {
            result = constructor.newInstance(null);
        }
        catch (IllegalArgumentException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (InstantiationException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (InvocationTargetException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }
}

