/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.classmap.Mappings;
import net.sf.dozer.util.mapping.converters.CustomConverterContainer;
import net.sf.dozer.util.mapping.converters.CustomConverterDescription;
import net.sf.dozer.util.mapping.util.ClassMapBuilder;
import net.sf.dozer.util.mapping.util.InitLogger;
import net.sf.dozer.util.mapping.util.LoadMappingsResult;
import net.sf.dozer.util.mapping.util.MappingFileReader;
import net.sf.dozer.util.mapping.util.MappingValidator;
import net.sf.dozer.util.mapping.util.MappingsParser;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomMappingsLoader {
    private static final Log log = LogFactory.getLog((Class)CustomMappingsLoader.class);

    public LoadMappingsResult load(List mappingFiles) {
        HashMap customMappings = new HashMap();
        ListOrderedSet customConverterDescriptions = new ListOrderedSet();
        Configuration globalConfiguration = new Configuration();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            InitLogger.log(log, "Using the following xml files to load custom mappings for the bean mapper instance: " + mappingFiles);
            Iterator iter = mappingFiles.iterator();
            while (iter.hasNext()) {
                String mappingFileName = (String)iter.next();
                InitLogger.log(log, "Trying to find xml mapping file: " + mappingFileName);
                URL url = MappingValidator.validateURL("" + mappingFileName);
                InitLogger.log(log, "Using URL [" + url + "] to load custom xml mappings");
                MappingFileReader mappingFileReader = new MappingFileReader(url);
                Mappings mappings = mappingFileReader.read();
                InitLogger.log(log, "Successfully loaded custom xml mappings from URL: [" + url + "]");
                globalConfiguration = mappings.getConfiguration();
                if (mappings.getConfiguration() != null && mappings.getConfiguration().getCustomConverters() != null && mappings.getConfiguration().getCustomConverters().getConverters() != null) {
                    Iterator iterator = mappings.getConfiguration().getCustomConverters().getConverters().iterator();
                    while (iterator.hasNext()) {
                        CustomConverterDescription cc = (CustomConverterDescription)iterator.next();
                        customConverterDescriptions.add((Object)cc);
                    }
                }
                MappingsParser mappingsParser = new MappingsParser();
                customMappings.putAll(mappingsParser.processMappings(mappings));
            }
        }
        ClassMapBuilder.addDefaultFieldMappings(customMappings, globalConfiguration);
        Iterator entries = customMappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ClassMap classMap = (ClassMap)entry.getValue();
            if (classMap.getCustomConverters() != null) {
                classMap.getCustomConverters().setConverters(customConverterDescriptions.asList());
                continue;
            }
            classMap.setCustomConverters(new CustomConverterContainer());
            classMap.getCustomConverters().setConverters(customConverterDescriptions.asList());
        }
        return new LoadMappingsResult(Collections.synchronizedMap(customMappings), globalConfiguration);
    }
}

