/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class CollectionUtils {
    public static boolean isArray(Class aClass) {
        return aClass.isArray();
    }

    public static boolean isCollection(Class aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    public static boolean isList(Class aClass) {
        return List.class.isAssignableFrom(aClass);
    }

    public static boolean isSet(Class aClass) {
        return Set.class.isAssignableFrom(aClass);
    }

    public static boolean isPrimitiveArray(Class aClass) {
        return aClass.isArray() && aClass.getComponentType().isPrimitive();
    }

    public static int getLengthOfCollection(Object value) {
        if (CollectionUtils.isArray(value.getClass())) {
            return Array.getLength(value);
        }
        return ((Collection)value).size();
    }

    public static Object getValueFromCollection(Object collection, int index) {
        if (CollectionUtils.isArray(collection.getClass())) {
            return Array.get(collection, index);
        }
        return ((Collection)collection).toArray()[index];
    }

    public static Set createNewSet(Class destType) {
        return CollectionUtils.createNewSet(destType, null);
    }

    public static Set createNewSet(Class destType, Collection srcValue) {
        AbstractSet result = null;
        result = SortedSet.class.isAssignableFrom(destType) ? new TreeSet() : new HashSet();
        if (srcValue != null) {
            result.addAll(srcValue);
        }
        return result;
    }

    public static Object convertListToArray(List list, Class destEntryType) {
        Object outArray = Array.newInstance(destEntryType, list.size());
        int count = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object element = list.get(i);
            Array.set(outArray, count, element);
            ++count;
        }
        return outArray;
    }

    public static List convertPrimitiveArrayToList(Object primitiveArray) {
        int length = Array.getLength(primitiveArray);
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(primitiveArray, i));
        }
        return result;
    }
}

