/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.util.ClassMapKeyFactory;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClassMapFinder {
    private static final Log log = LogFactory.getLog((Class)ClassMapFinder.class);

    public static ClassMap findClassMap(Map customMappings, Class srcClass, Class destClass, String mapId) {
        Class destLookupClass;
        Class srcLookupClass = MappingUtils.isProxy(srcClass) ? MappingUtils.getProxyRealClass(srcClass) : srcClass;
        ClassMap mapping = (ClassMap)customMappings.get(ClassMapKeyFactory.createKey(srcLookupClass, destLookupClass = MappingUtils.isProxy(destClass) ? MappingUtils.getProxyRealClass(destClass) : destClass, mapId));
        if (mapping == null) {
            mapping = ClassMapFinder.findInterfaceMapping(customMappings, destClass, srcClass, mapId);
        }
        if (mapId != null && mapping == null) {
            Iterator iter = customMappings.entrySet().iterator();
            ClassMap classMap = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                classMap = (ClassMap)entry.getValue();
                if (!StringUtils.equals((String)classMap.getMapId(), (String)mapId)) continue;
                return classMap;
            }
            log.info((Object)("No ClassMap found for mapId:" + mapId));
        }
        return mapping;
    }

    public static List findInterfaceMappings(Map customMappings, Class srcClass, Class destClass) {
        ClassMap interfaceClassMap;
        int i;
        Class<?>[] srcInterfaces = srcClass.getInterfaces();
        Class<?>[] destInterfaces = destClass.getInterfaces();
        ArrayList<ClassMap> interfaceMaps = new ArrayList<ClassMap>();
        int size = destInterfaces.length;
        for (i = 0; i < size; ++i) {
            interfaceClassMap = (ClassMap)customMappings.get(ClassMapKeyFactory.createKey(srcClass, destInterfaces[i]));
            if (interfaceClassMap == null) continue;
            interfaceMaps.add(interfaceClassMap);
        }
        for (i = 0; i < srcInterfaces.length; ++i) {
            interfaceClassMap = (ClassMap)customMappings.get(ClassMapKeyFactory.createKey(srcInterfaces[i], destClass));
            if (interfaceClassMap == null) continue;
            interfaceMaps.add(interfaceClassMap);
        }
        Collections.reverse(interfaceMaps);
        return interfaceMaps;
    }

    private static ClassMap findInterfaceMapping(Map customMappings, Class destClass, Class srcClass, String mapId) {
        Object[] keys = customMappings.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            ClassMap map = (ClassMap)customMappings.get(keys[i]);
            Class mappingDestClass = map.getDestClassToMap();
            Class mappingSrcClass = map.getSrcClassToMap();
            if (mapId == null && map.getMapId() != null || mapId != null && !mapId.equals(map.getMapId())) continue;
            if (mappingSrcClass.isInterface() && mappingSrcClass.isAssignableFrom(srcClass)) {
                if (mappingDestClass.isInterface() && mappingDestClass.isAssignableFrom(destClass)) {
                    return map;
                }
                if (destClass.equals(mappingDestClass)) {
                    return map;
                }
            }
            if (!mappingDestClass.isInterface() || !mappingDestClass.isAssignableFrom(destClass) || !srcClass.equals(mappingSrcClass)) continue;
            return map;
        }
        return null;
    }
}

