/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.util;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.classmap.DozerClass;
import net.sf.dozer.util.mapping.fieldmap.CustomGetSetMethodFieldMap;
import net.sf.dozer.util.mapping.fieldmap.DozerField;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.fieldmap.GenericFieldMap;
import net.sf.dozer.util.mapping.fieldmap.MapFieldMap;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class ClassMapBuilder {
    public static ClassMap createDefaultClassMap(Configuration globalConfiguration, Class srcClass, Class destClass) {
        ClassMap classMap = new ClassMap(globalConfiguration);
        classMap.setSrcClass(new DozerClass(srcClass.getName(), srcClass, globalConfiguration.getBeanFactory(), null, null, null, true, true));
        classMap.setDestClass(new DozerClass(destClass.getName(), destClass, globalConfiguration.getBeanFactory(), null, null, null, true, true));
        if (classMap.isWildcard()) {
            ClassMapBuilder.addDefaultFieldMappings(classMap, globalConfiguration);
        }
        return classMap;
    }

    public static void addDefaultFieldMappings(Map customMappings, Configuration globalConfiguration) {
        Set entries = customMappings.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ClassMap classMap = (ClassMap)entry.getValue();
            if (!classMap.isWildcard()) continue;
            ClassMapBuilder.addDefaultFieldMappings(classMap, globalConfiguration);
        }
    }

    private static void addDefaultFieldMappings(ClassMap classMap, Configuration globalConfiguration) {
        Class srcClass = classMap.getSrcClassToMap();
        Class destClass = classMap.getDestClassToMap();
        if (MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null || MappingUtils.isSupportedMap(destClass) || classMap.getDestClassMapGetMethod() != null) {
            ClassMapBuilder.addMapDefaultFieldMappings(classMap);
            return;
        }
        PropertyDescriptor[] destProperties = ReflectionUtils.getPropertyDescriptors(destClass);
        for (int i = 0; i < destProperties.length; ++i) {
            PropertyDescriptor srcProperty;
            PropertyDescriptor destPropertyDescriptor = destProperties[i];
            String destFieldName = destPropertyDescriptor.getName();
            if (destFieldName.equals("class") || classMap.getFieldMapUsingDest(destFieldName) != null || (destFieldName.equals("callback") || destFieldName.equals("callbacks")) && destClass.getName().indexOf("$$EnhancerByCGLIB$$") >= 0 || destPropertyDescriptor.getWriteMethod() == null || (srcProperty = ReflectionUtils.findPropertyDescriptor(srcClass, destFieldName, null)) == null || srcProperty.getReadMethod() == null) continue;
            FieldMap map = null;
            DozerField field = new DozerField(destFieldName, null);
            map = field.isCustomGetterSetterField() ? new CustomGetSetMethodFieldMap(classMap) : new GenericFieldMap(classMap);
            map.setSrcField(new DozerField(destFieldName, null));
            map.setDestField(new DozerField(destFieldName, null));
            MappingUtils.applyGlobalCopyByReference(globalConfiguration, map, classMap);
            classMap.addFieldMapping(map);
        }
    }

    private static void addMapDefaultFieldMappings(ClassMap classMap) {
        Class srcClass = classMap.getSrcClassToMap();
        Class destClass = classMap.getDestClassToMap();
        PropertyDescriptor[] properties = null;
        boolean destIsMap = false;
        if (MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null) {
            properties = ReflectionUtils.getPropertyDescriptors(destClass);
        } else if (MappingUtils.isSupportedMap(destClass) || classMap.getDestClassMapGetMethod() != null) {
            properties = ReflectionUtils.getPropertyDescriptors(srcClass);
            destIsMap = true;
        } else {
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            String fieldName = properties[i].getName();
            if (fieldName.equals("class") || (fieldName.equals("callback") || fieldName.equals("callbacks")) && (destClass.getName().indexOf("$$EnhancerByCGLIB$$") >= 0 || srcClass.getName().indexOf("$$EnhancerByCGLIB$$") >= 0) || destIsMap && classMap.getFieldMapUsingSrc(fieldName) != null || !destIsMap && classMap.getFieldMapUsingDest(fieldName) != null) continue;
            MapFieldMap map = new MapFieldMap(classMap);
            DozerField srcField = new DozerField(MappingUtils.isSupportedMap(srcClass) ? "this" : fieldName, null);
            srcField.setKey(fieldName);
            if (StringUtils.isNotEmpty((String)classMap.getSrcClassMapGetMethod()) || StringUtils.isNotEmpty((String)classMap.getSrcClassMapSetMethod())) {
                srcField.setMapGetMethod(classMap.getSrcClassMapGetMethod());
                srcField.setMapSetMethod(classMap.getSrcClassMapSetMethod());
                srcField.setName("this");
            }
            DozerField destField = new DozerField(MappingUtils.isSupportedMap(destClass) ? "this" : fieldName, null);
            srcField.setKey(fieldName);
            if (StringUtils.isNotEmpty((String)classMap.getDestClassMapGetMethod()) || StringUtils.isNotEmpty((String)classMap.getDestClassMapSetMethod())) {
                destField.setMapGetMethod(classMap.getDestClassMapGetMethod());
                destField.setMapSetMethod(classMap.getDestClassMapSetMethod());
                destField.setName("this");
            }
            map.setSrcField(srcField);
            map.setDestField(destField);
            classMap.addFieldMapping(map);
        }
    }
}

