/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.stats;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.config.GlobalSettings;
import net.sf.dozer.util.mapping.stats.Statistic;
import net.sf.dozer.util.mapping.stats.StatisticEntry;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StatisticsManager
implements StatisticsManagerIF {
    private static final Log log = LogFactory.getLog((Class)StatisticsManager.class);
    private final Map statisticsMap = new HashMap();
    private boolean isStatisticsEnabled = GlobalSettings.getInstance().isStatisticsEnabled();

    public void clearAll() {
        this.statisticsMap.clear();
    }

    public Set getStatisticEntries(String statisticType) {
        return this.getStatistic(statisticType).getEntries();
    }

    public Set getStatistics() {
        return new HashSet(this.statisticsMap.values());
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.isStatisticsEnabled = statisticsEnabled;
        GlobalSettings.getInstance().setStatisticsEnabled(statisticsEnabled);
    }

    public Statistic getStatistic(String statisticType) {
        Statistic result = (Statistic)this.statisticsMap.get(statisticType);
        if (result == null) {
            MappingUtils.throwMappingException("Unable to find statistic for type: " + statisticType);
        }
        return result;
    }

    public Set getStatisticTypes() {
        HashSet results = new HashSet();
        Iterator iter = this.statisticsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            results.add(entry.getKey());
        }
        return results;
    }

    public void increment(String statisticType) {
        this.increment(statisticType, 1L);
    }

    public void increment(String statisticType, long value) {
        this.increment(statisticType, statisticType, value);
    }

    public void increment(String statisticType, Object statisticEntryKey) {
        this.increment(statisticType, statisticEntryKey, 1L);
    }

    public void increment(String statisticType, Object statisticEntryKey, long value) {
        if (!this.isStatisticsEnabled()) {
            return;
        }
        if (statisticType == null) {
            throw new IllegalArgumentException("statistic type must be specified");
        }
        if (statisticEntryKey == null) {
            throw new IllegalArgumentException("statistic entry key must be specified");
        }
        Statistic statistic = (Statistic)this.statisticsMap.get(statisticType);
        if (statistic == null) {
            statistic = new Statistic(statisticType);
            this.addStatistic(statistic);
        }
        StatisticEntry statisticEntry = null;
        statisticEntry = statistic.getEntry(statisticEntryKey);
        if (statisticEntry == null) {
            statisticEntry = new StatisticEntry(statisticEntryKey);
            statistic.addEntry(statisticEntry);
        }
        statisticEntry.increment(value);
    }

    public long getStatisticValue(String statisticType) {
        Set entries = this.getStatistic(statisticType).getEntries();
        if (entries.size() > 1) {
            throw new IllegalArgumentException("More than one value entry found for stat type: " + statisticType);
        }
        return ((StatisticEntry)entries.iterator().next()).getValue();
    }

    public void addStatistic(Statistic statistic) {
        if (this.statisticExists(statistic.getType())) {
            throw new IllegalArgumentException("Statistic already exists for type: " + statistic.getType());
        }
        this.statisticsMap.put(statistic.getType(), statistic);
    }

    public boolean statisticExists(String statisticType) {
        return this.statisticsMap.containsKey(statisticType);
    }

    public void logStatistics() {
        log.info((Object)this.getStatistics());
    }
}

