/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.stats;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.stats.StatisticEntry;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Statistic {
    private final String type;
    private final Map entriesMap = new HashMap();

    public Statistic(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void clear() {
        this.entriesMap.clear();
    }

    public Set getEntries() {
        return new HashSet(this.entriesMap.values());
    }

    public void addEntry(StatisticEntry statEntry) {
        if (statEntry == null) {
            throw new IllegalArgumentException("Statistic Entry cannot be null");
        }
        this.entriesMap.put(statEntry.getKey(), statEntry);
    }

    public StatisticEntry getEntry() {
        return this.getEntry(this.type);
    }

    public StatisticEntry getEntry(Object entryKey) {
        return (StatisticEntry)this.entriesMap.get(entryKey);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Statistic)) {
            return false;
        }
        Statistic entry = (Statistic)object;
        return new EqualsBuilder().append((Object)this.getType(), (Object)entry.getType()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).toHashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

