/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.dozer.util.mapping.DozerBeanMapper;
import net.sf.dozer.util.mapping.MapperIF;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class DozerBeanMapperFactoryBean
implements FactoryBean,
InitializingBean {
    private DozerBeanMapper beanMapper;
    private Resource[] mappingFiles;
    private List customConverters;
    private List eventListeners;
    private Map factories;

    public final void setMappingFiles(Resource[] mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public final void setCustomConverters(List customConverters) {
        this.customConverters = customConverters;
    }

    public final void setEventListeners(List eventListeners) {
        this.eventListeners = eventListeners;
    }

    public final void setFactories(Map factories) {
        this.factories = factories;
    }

    public final Object getObject() throws Exception {
        return this.beanMapper;
    }

    public final Class getObjectType() {
        return MapperIF.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        this.beanMapper = new DozerBeanMapper();
        if (this.mappingFiles != null) {
            ArrayList<String> mappings = new ArrayList<String>(this.mappingFiles.length);
            for (int i = 0; i < this.mappingFiles.length; ++i) {
                mappings.add("file:" + this.mappingFiles[i].getFile().toString());
            }
            this.beanMapper.setMappingFiles(mappings);
        }
        if (this.customConverters != null) {
            this.beanMapper.setCustomConverters(this.customConverters);
        }
        if (this.eventListeners != null) {
            this.beanMapper.setEventListeners(this.eventListeners);
        }
        if (this.factories != null) {
            this.beanMapper.setFactories(this.factories);
        }
    }
}

