/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.propertydescriptor;

import java.lang.reflect.Method;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.fieldmap.HintContainer;
import net.sf.dozer.util.mapping.propertydescriptor.GetterSetterPropertyDescriptor;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.ReflectionUtils;

public class MapPropertyDescriptor
extends GetterSetterPropertyDescriptor {
    private final String setMethod;
    private final String getMethod;
    private final String key;
    private Method writeMethod;
    private Method readMethod;

    public MapPropertyDescriptor(Class clazz, String fieldName, boolean isIndexed, int index, String setMethod, String getMethod, String key, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        this.setMethod = setMethod;
        this.getMethod = getMethod;
        this.key = key;
    }

    public Method getWriteMethod() throws NoSuchMethodException {
        if (MappingUtils.isBlankOrNull(this.setMethod)) {
            throw new MappingException("Custom Map set method not specified for field mapping to class: " + this.clazz + ".  Perhaps the map-set-method wasn't specified in the dozer mapping file?");
        }
        if (this.writeMethod == null) {
            this.writeMethod = ReflectionUtils.getMethod(this.clazz, this.setMethod);
        }
        return this.writeMethod;
    }

    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (this.isDeepField()) {
            this.writeDeepDestinationValue(bean, value, fieldMap);
        } else if (!this.getPropertyType().isPrimitive() || value != null) {
            try {
                if (this.getPropertyValue(bean) == value) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.invokeWriteMethod(bean, value);
        }
    }

    protected Method getReadMethod() throws NoSuchMethodException {
        if (MappingUtils.isBlankOrNull(this.getMethod)) {
            throw new MappingException("Custom Map get method not specified for field mapping to class: " + this.clazz + ".  Perhaps the map-get-method wasn't specified in the dozer mapping file?");
        }
        if (this.readMethod == null) {
            this.readMethod = ReflectionUtils.getMethod(this.clazz, this.getMethod);
        }
        return this.readMethod;
    }

    protected String getSetMethodName() throws NoSuchMethodException {
        return this.setMethod;
    }

    protected void invokeWriteMethod(Object target, Object value) {
        if (this.key == null) {
            throw new MappingException("key must be specified");
        }
        try {
            ReflectionUtils.invoke(this.getWriteMethod(), target, new Object[]{this.key, value});
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
    }

    protected Object invokeReadMethod(Object target) {
        if (this.key == null) {
            throw new MappingException("key must be specified");
        }
        Object result = null;
        try {
            result = ReflectionUtils.invoke(this.getReadMethod(), target, new Object[]{this.key});
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }
}

