/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.propertydescriptor;

import java.lang.reflect.Field;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.fieldmap.HintContainer;
import net.sf.dozer.util.mapping.propertydescriptor.AbstractPropertyDescriptor;
import net.sf.dozer.util.mapping.propertydescriptor.DozerPropertyDescriptorIF;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.ReflectionUtils;

public class FieldPropertyDescriptor
extends AbstractPropertyDescriptor
implements DozerPropertyDescriptorIF {
    private Field field;

    public FieldPropertyDescriptor(Class clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        try {
            this.field = ReflectionUtils.getFieldFromBean(clazz, fieldName);
        }
        catch (NoSuchFieldException e) {
            MappingUtils.throwMappingException(e);
        }
        this.field.setAccessible(true);
    }

    public Class getPropertyType() {
        return this.field.getType();
    }

    public Object getPropertyValue(Object bean) {
        Object result = null;
        try {
            result = this.field.get(bean);
        }
        catch (IllegalArgumentException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        if (this.isIndexed) {
            result = MappingUtils.getIndexedValue(result, this.index);
        }
        return result;
    }

    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (this.getPropertyType().isPrimitive() && value == null) {
            return;
        }
        if (this.getPropertyValue(bean) == value) {
            return;
        }
        try {
            if (this.isIndexed) {
                Object existingValue = this.field.get(bean);
                this.field.set(bean, this.prepareIndexedCollection(existingValue, value));
            } else {
                this.field.set(bean, value);
            }
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
    }
}

