/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.jmx;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sf.dozer.util.mapping.config.GlobalSettings;
import net.sf.dozer.util.mapping.jmx.DozerStatisticsControllerMBean;
import net.sf.dozer.util.mapping.stats.GlobalStatistics;
import net.sf.dozer.util.mapping.stats.StatisticEntry;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;

public class DozerStatisticsController
implements DozerStatisticsControllerMBean {
    private final StatisticsManagerIF statsMgr = GlobalStatistics.getInstance().getStatsMgr();

    public void clearAll() {
        this.statsMgr.clearAll();
    }

    public boolean isStatisticsEnabled() {
        return GlobalSettings.getInstance().isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        GlobalSettings.getInstance().setStatisticsEnabled(statisticsEnabled);
    }

    public long getMappingSuccessCount() {
        return this.getStatisticValue("Mapping Success Count");
    }

    public long getMappingFailureCount() {
        return this.getStatisticValue("Mapping Failure Count");
    }

    public long getMapperInstancesCount() {
        return this.getStatisticValue("Mapper Instances Count");
    }

    public long getMappingOverallTime() {
        return this.getStatisticValue("Mapping Overall Time(ms)");
    }

    public Set getMappingFailureExceptionTypes() {
        return this.getStatisticEntries("Mapping Failure Exception Type Count");
    }

    public Set getMappingFailureTypes() {
        return this.getStatisticEntries("Mapping Failure Type Count");
    }

    public Set getCacheHitCount() {
        return this.getStatisticEntries("Cache Hit Count");
    }

    public Set getCacheMissCount() {
        return this.getStatisticEntries("Cache Miss Count");
    }

    public long getFieldMappingSuccessCount() {
        return this.getStatisticValue("Field Mapping Success Count");
    }

    public long getFieldMappingFailureCount() {
        return this.getStatisticValue("Field Mapping Failure Count");
    }

    public long getFieldMappingFailureIgnoredCount() {
        return this.getStatisticValue("Field Mapping Failure Ignored Count");
    }

    public long getCustomConverterSuccessCount() {
        return this.getStatisticValue("Custom Converter Success Count");
    }

    public long getCustomConverterOverallTime() {
        return this.getStatisticValue("Custom Converter Overall Time(ms)");
    }

    public Set getStatisticTypes() {
        return this.statsMgr.getStatisticTypes();
    }

    public double getMappingAverageTime() {
        double totalTime = this.getStatisticValue("Mapping Overall Time(ms)");
        double totalCount = this.getStatisticValue("Mapping Success Count");
        return totalTime / totalCount;
    }

    public double getCustomConverterAverageTime() {
        double totalTime = this.getStatisticValue("Custom Converter Overall Time(ms)");
        double totalCount = this.getStatisticValue("Custom Converter Success Count");
        return totalTime / totalCount;
    }

    public double getCustomConverterPercentageOfMappingTime() {
        double ccTotalTime = this.getStatisticValue("Custom Converter Overall Time(ms)");
        double overallTime = this.getStatisticValue("Mapping Overall Time(ms)");
        return ccTotalTime / overallTime * 100.0;
    }

    public Set getStatisticEntries(String statisticType) {
        TreeSet<String> result = new TreeSet<String>();
        if (this.statsMgr.statisticExists(statisticType)) {
            Set entries = this.statsMgr.getStatisticEntries(statisticType);
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                StatisticEntry entry = (StatisticEntry)iter.next();
                result.add(entry.getKey().toString() + ":Count " + entry.getValue());
            }
        }
        return result;
    }

    public void logStatistics() {
        this.statsMgr.logStatistics();
    }

    public String dumpStatistics() {
        return this.statsMgr.getStatistics().toString();
    }

    protected long getStatisticValue(String statisticType) {
        long result = 0L;
        if (this.statsMgr.statisticExists(statisticType)) {
            result = this.statsMgr.getStatisticValue(statisticType);
        }
        return result;
    }
}

