/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import net.sf.dozer.util.mapping.util.MappingUtils;

public class StatisticsInterceptor
implements InvocationHandler {
    private final Object delegate;
    private final StatisticsManagerIF statsMgr;

    public StatisticsInterceptor(Object delegate, StatisticsManagerIF statsMgr) {
        this.delegate = delegate;
        this.statsMgr = statsMgr;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object result = method.invoke(this.delegate, args);
            long stop = System.currentTimeMillis();
            this.statsMgr.increment("Mapping Success Count");
            this.statsMgr.increment("Mapping Overall Time(ms)", stop - start);
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            this.statsMgr.increment("Mapping Failure Count");
            Throwable rootCause = MappingUtils.getRootCause(ex);
            this.statsMgr.increment("Mapping Failure Exception Type Count", rootCause.getClass());
            this.incrementClassMappingFailureTypeStat(args);
            throw ex;
        }
    }

    private void incrementClassMappingFailureTypeStat(Object[] args) {
        String srcClassName = null;
        if (args[0] != null) {
            srcClassName = args[0].getClass().getName();
        }
        String destClassName = null;
        if (args[1] != null) {
            destClassName = args[1] instanceof Class ? ((Class)args[1]).getName() : args[1].getClass().getName();
        }
        this.statsMgr.increment("Mapping Failure Type Count", srcClassName + "-->" + destClassName);
    }
}

