/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.fieldmap;

import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.propertydescriptor.AbstractPropertyDescriptor;
import net.sf.dozer.util.mapping.propertydescriptor.DozerPropertyDescriptorIF;
import net.sf.dozer.util.mapping.propertydescriptor.FieldPropertyDescriptor;
import net.sf.dozer.util.mapping.propertydescriptor.JavaBeanPropertyDescriptor;
import net.sf.dozer.util.mapping.propertydescriptor.MapPropertyDescriptor;
import net.sf.dozer.util.mapping.util.DestBeanCreator;
import net.sf.dozer.util.mapping.util.MappingUtils;

public class MapFieldMap
extends FieldMap {
    public MapFieldMap(ClassMap classMap) {
        super(classMap);
    }

    public MapFieldMap(FieldMap fieldMap) {
        super(fieldMap.getClassMap());
        this.setCopyByReference(fieldMap.isCopyByReference());
        this.setCustomConverter(fieldMap.getCustomConverter());
        this.setCustomConverterId(fieldMap.getCustomConverterId());
        this.setDestField(fieldMap.getDestField());
        this.setDestHintContainer(fieldMap.getDestHintContainer());
        this.setDestDeepIndexHintContainer(fieldMap.getDestDeepIndexHintContainer());
        this.setMapId(fieldMap.getMapId());
        this.setRelationshipType(fieldMap.getRelationshipType());
        this.setRemoveOrphans(fieldMap.isRemoveOrphans());
        this.setSrcField(fieldMap.getSrcField());
        this.setSrcHintContainer(fieldMap.getSrcHintContainer());
        this.setSrcDeepIndexHintContainer(fieldMap.getSrcDeepIndexHintContainer());
        this.setType(fieldMap.getType());
    }

    public void writeDestValue(Object destObj, Object destFieldValue) {
        DozerPropertyDescriptorIF propDescriptor;
        Object targetObject = destObj;
        if (this.getDestFieldName().equals("this") || destFieldValue != null && MappingUtils.isSupportedMap(destFieldValue.getClass())) {
            propDescriptor = super.getDestPropertyDescriptor(destObj.getClass());
        } else if (this.getDestFieldMapGetMethod() != null || MappingUtils.isSupportedMap(this.determineActualPropertyType(this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), destObj, true))) {
            PrepareTargetObjectResult result = this.prepareTargetObject(destObj);
            targetObject = result.targetObject;
            propDescriptor = result.propDescriptor;
        } else {
            propDescriptor = super.getDestPropertyDescriptor(destObj.getClass());
        }
        propDescriptor.setPropertyValue(targetObject, destFieldValue, this);
    }

    public Object getSrcFieldValue(Object srcObj) {
        DozerPropertyDescriptorIF propDescriptor;
        Object targetObject = srcObj;
        if (this.getSrcFieldName().equals("this")) {
            propDescriptor = super.getSrcPropertyDescriptor(srcObj.getClass());
        } else {
            Class ac = this.determineActualPropertyType(this.getSrcFieldName(), this.isSrcFieldIndexed(), this.getSrcFieldIndex(), srcObj, false);
            if (this.getSrcFieldMapGetMethod() != null || this.getMapId() == null && MappingUtils.isSupportedMap(ac) && this.getSrcHintContainer() == null) {
                targetObject = super.getSrcFieldValue(srcObj);
                propDescriptor = new MapPropertyDescriptor(ac, this.getSrcFieldName(), this.isSrcFieldIndexed(), this.getDestFieldIndex(), MappingUtils.isSupportedMap(ac) ? "put" : this.getSrcFieldMapSetMethod(), MappingUtils.isSupportedMap(ac) ? "get" : this.getSrcFieldMapGetMethod(), this.getSrcFieldKey() != null ? this.getSrcFieldKey() : this.getDestFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer());
            } else {
                propDescriptor = super.getSrcPropertyDescriptor(srcObj.getClass());
            }
        }
        Object result = null;
        if (targetObject != null) {
            result = propDescriptor.getPropertyValue(targetObject);
        }
        return result;
    }

    private PrepareTargetObjectResult prepareTargetObject(Object destObj) {
        AbstractPropertyDescriptor pd = this.isDestFieldAccessible() ? new FieldPropertyDescriptor(destObj.getClass(), this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer()) : new JavaBeanPropertyDescriptor(destObj.getClass(), this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer());
        Class c = pd.getPropertyType();
        Object targetObject = pd.getPropertyValue(destObj);
        if (targetObject == null) {
            if (this.getDestHintContainer() != null) {
                if (MappingUtils.isSupportedMap(c)) {
                    if (MappingUtils.isSupportedMap(this.getDestHintContainer().getHint())) {
                        c = this.getDestHintContainer().getHint();
                    }
                } else {
                    c = this.getDestHintContainer().getHint();
                }
            }
            targetObject = DestBeanCreator.create(c, destObj.getClass());
            pd.setPropertyValue(destObj, targetObject, this);
        }
        return new PrepareTargetObjectResult(targetObject, new MapPropertyDescriptor(c, this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), MappingUtils.isSupportedMap(c) ? "put" : this.getDestFieldMapSetMethod(), MappingUtils.isSupportedMap(c) ? "get" : this.getDestFieldMapGetMethod(), this.getDestFieldKey() != null ? this.getDestFieldKey() : this.getSrcFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer()));
    }

    private Class determineActualPropertyType(String fieldName, boolean isIndexed, int index, Object targetObj, boolean isDestObj) {
        AbstractPropertyDescriptor pd = isDestObj && this.isDestFieldAccessible() || !isDestObj && this.isSrcFieldAccessible() ? new FieldPropertyDescriptor(targetObj.getClass(), fieldName, isIndexed, index, this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer()) : new JavaBeanPropertyDescriptor(targetObj.getClass(), fieldName, isIndexed, index, this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer());
        return pd.getPropertyType();
    }

    private class PrepareTargetObjectResult {
        private Object targetObject;
        private MapPropertyDescriptor propDescriptor;

        public PrepareTargetObjectResult(Object targetObject, MapPropertyDescriptor propDescriptor) {
            this.targetObject = targetObject;
            this.propDescriptor = propDescriptor;
        }
    }
}

