/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.fieldmap;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class HintContainer {
    private String hintName;
    private List hints;

    public Class getHint() {
        Class result = null;
        if (this.hasMoreThanOneHint()) {
            return null;
        }
        result = (Class)this.getHints().get(0);
        return result;
    }

    public Class getHint(int index) {
        return (Class)this.getHints().get(index);
    }

    public boolean hasMoreThanOneHint() {
        return this.getHints().size() > 1;
    }

    public List getHints() {
        if (this.hints == null) {
            ArrayList<Class> list = new ArrayList<Class>();
            StringTokenizer st = new StringTokenizer(this.hintName, ",");
            while (st.hasMoreElements()) {
                String theHintName = st.nextToken().trim();
                Class clazz = MappingUtils.loadClass(theHintName);
                list.add(clazz);
            }
            this.hints = list;
        }
        return this.hints;
    }

    public Class getHint(Class clazz, List clazzHints) {
        List hints = this.getHints();
        int hintsSize = hints.size();
        if (hintsSize == 1) {
            return this.getHint();
        }
        if (clazzHints.size() != hintsSize) {
            MappingUtils.throwMappingException("When using multiple source and destination hints there must be exactly the same number of hints on the source and the destination.");
        }
        int count = 0;
        String myClazName = MappingUtils.isProxy(clazz) ? MappingUtils.getProxyRealClass(clazz).getName() : clazz.getName();
        int size = clazzHints.size();
        for (int i = 0; i < size; ++i) {
            Class element = (Class)clazzHints.get(i);
            if (element.getName().equals(myClazName)) {
                return (Class)hints.get(count++);
            }
            ++count;
        }
        return clazz;
    }

    public void setHintName(String hintName) {
        this.hintName = hintName;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

