/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.fieldmap;

import java.lang.reflect.Method;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.fieldmap.DozerField;
import net.sf.dozer.util.mapping.fieldmap.HintContainer;
import net.sf.dozer.util.mapping.propertydescriptor.DozerPropertyDescriptorIF;
import net.sf.dozer.util.mapping.propertydescriptor.GetterSetterPropertyDescriptor;
import net.sf.dozer.util.mapping.propertydescriptor.PropertyDescriptorFactory;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FieldMap
implements Cloneable {
    private static final Log log = LogFactory.getLog((Class)FieldMap.class);
    private ClassMap classMap;
    private DozerField srcField;
    private DozerField destField;
    private HintContainer srcHintContainer;
    private HintContainer destHintContainer;
    private HintContainer srcDeepIndexHintContainer;
    private HintContainer destDeepIndexHintContainer;
    private String type;
    private boolean copyByReference;
    private boolean copyByReferenceOveridden;
    private String mapId;
    private String customConverter;
    private String customConverterId;
    private String relationshipType;
    private boolean removeOrphans;

    public FieldMap(ClassMap classMap) {
        this.classMap = classMap;
    }

    public ClassMap getClassMap() {
        return this.classMap;
    }

    public void setClassMap(ClassMap classMap) {
        this.classMap = classMap;
    }

    public Object getSrcFieldValue(Object runtimeSrcObj) {
        return this.getSrcPropertyDescriptor(runtimeSrcObj.getClass()).getPropertyValue(runtimeSrcObj);
    }

    public void writeDestValue(Object runtimeDestObj, Object destFieldValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting ready to invoke write method on the destination object.  Dest Obj: " + MappingUtils.getClassNameWithoutPackage(runtimeDestObj.getClass()) + ", Dest value: " + destFieldValue));
        }
        DozerPropertyDescriptorIF propDescriptor = this.getDestPropertyDescriptor(runtimeDestObj.getClass());
        propDescriptor.setPropertyValue(runtimeDestObj, destFieldValue, this);
    }

    public Class getDestHintType(Class runtimeSrcClass) {
        if (this.getDestHintContainer() != null) {
            if (this.getSrcHintContainer() != null) {
                return this.getDestHintContainer().getHint(runtimeSrcClass, this.getSrcHintContainer().getHints());
            }
            return this.getDestHintContainer().getHint();
        }
        return runtimeSrcClass;
    }

    public Class getDestFieldType(Class runtimeDestClass) {
        Class result = null;
        if (this.isDestFieldIndexed()) {
            Class clazz = result = this.destHintContainer != null ? this.destHintContainer.getHint() : null;
        }
        if (result == null) {
            result = this.getDestPropertyDescriptor(runtimeDestClass).getPropertyType();
        }
        return result;
    }

    public Class getSrcFieldType(Class runtimeSrcClass) {
        return this.getSrcPropertyDescriptor(runtimeSrcClass).getPropertyType();
    }

    public Method getDestFieldWriteMethod(Class runtimeDestClass) {
        DozerPropertyDescriptorIF dpd = this.getDestPropertyDescriptor(runtimeDestClass);
        Method result = null;
        try {
            result = ((GetterSetterPropertyDescriptor)dpd).getWriteMethod();
        }
        catch (Exception e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public Object getDestValue(Object runtimeDestObj) {
        return this.getDestPropertyDescriptor(runtimeDestObj.getClass()).getPropertyValue(runtimeDestObj);
    }

    public HintContainer getDestHintContainer() {
        return this.destHintContainer;
    }

    public void setDestHintContainer(HintContainer destHint) {
        this.destHintContainer = destHint;
    }

    public HintContainer getSrcHintContainer() {
        return this.srcHintContainer;
    }

    public void setSrcHintContainer(HintContainer sourceHint) {
        this.srcHintContainer = sourceHint;
    }

    public String getSrcFieldMapGetMethod() {
        return !MappingUtils.isBlankOrNull(this.srcField.getMapGetMethod()) ? this.srcField.getMapGetMethod() : this.classMap.getSrcClassMapGetMethod();
    }

    public String getSrcFieldMapSetMethod() {
        return !MappingUtils.isBlankOrNull(this.srcField.getMapSetMethod()) ? this.srcField.getMapSetMethod() : this.classMap.getSrcClassMapSetMethod();
    }

    public String getDestFieldMapGetMethod() {
        return !MappingUtils.isBlankOrNull(this.destField.getMapGetMethod()) ? this.destField.getMapGetMethod() : this.classMap.getDestClassMapGetMethod();
    }

    public String getDestFieldMapSetMethod() {
        return !MappingUtils.isBlankOrNull(this.destField.getMapSetMethod()) ? this.destField.getMapSetMethod() : this.classMap.getDestClassMapSetMethod();
    }

    public String getSrcFieldName() {
        return this.srcField.getName();
    }

    public String getDestFieldName() {
        return this.destField.getName();
    }

    public String getDestFieldType() {
        return this.destField.getType();
    }

    public String getSrcFieldType() {
        return this.srcField.getType();
    }

    public String getSrcFieldDateFormat() {
        return this.getDateFormat();
    }

    public String getDestFieldDateFormat() {
        return this.getDateFormat();
    }

    public String getDateFormat() {
        if (!MappingUtils.isBlankOrNull(this.destField.getDateFormat())) {
            return this.destField.getDateFormat();
        }
        if (!MappingUtils.isBlankOrNull(this.srcField.getDateFormat())) {
            return this.srcField.getDateFormat();
        }
        return this.classMap.getDateFormat();
    }

    public String getDestFieldCreateMethod() {
        return this.destField.getCreateMethod();
    }

    public String getSrcFieldCreateMethod() {
        return this.srcField.getCreateMethod();
    }

    public boolean isDestFieldIndexed() {
        return this.destField.isIndexed();
    }

    public boolean isSrcFieldIndexed() {
        return this.srcField.isIndexed();
    }

    public int getSrcFieldIndex() {
        return this.srcField.getIndex();
    }

    public int getDestFieldIndex() {
        return this.destField.getIndex();
    }

    public String getSrcFieldTheGetMethod() {
        return this.srcField.getTheGetMethod();
    }

    public String getDestFieldTheGetMethod() {
        return this.destField.getTheGetMethod();
    }

    public String getSrcFieldTheSetMethod() {
        return this.srcField.getTheSetMethod();
    }

    public String getDestFieldTheSetMethod() {
        return this.destField.getTheSetMethod();
    }

    public String getSrcFieldKey() {
        return this.srcField.getKey();
    }

    public String getDestFieldKey() {
        return this.destField.getKey();
    }

    public boolean isDestFieldAccessible() {
        return this.destField.isAccessible();
    }

    public boolean isSrcFieldAccessible() {
        return this.srcField.isAccessible();
    }

    public void setSrcField(DozerField sourceField) {
        this.srcField = sourceField;
    }

    public void setDestField(DozerField destField) {
        this.destField = destField;
    }

    public HintContainer getDestDeepIndexHintContainer() {
        return this.destDeepIndexHintContainer;
    }

    public void setDestDeepIndexHintContainer(HintContainer destDeepIndexHintHint) {
        this.destDeepIndexHintContainer = destDeepIndexHintHint;
    }

    public HintContainer getSrcDeepIndexHintContainer() {
        return this.srcDeepIndexHintContainer;
    }

    public void setSrcDeepIndexHintContainer(HintContainer srcDeepIndexHint) {
        this.srcDeepIndexHintContainer = srcDeepIndexHint;
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isCopyByReference() {
        return this.copyByReference;
    }

    public void setCopyByReference(boolean copyByReference) {
        this.copyByReference = copyByReference;
        this.copyByReferenceOveridden = true;
    }

    protected boolean isSrcSelfReferencing() {
        return this.getSrcFieldName().equals("this");
    }

    protected boolean isDestSelfReferencing() {
        return this.getDestFieldName().equals("this");
    }

    public boolean isCopyByReferenceOveridden() {
        return this.copyByReferenceOveridden;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public String getCustomConverter() {
        return this.customConverter;
    }

    public void setCustomConverter(String customConverter) {
        this.customConverter = customConverter;
    }

    public String getRelationshipType() {
        return this.relationshipType != null ? this.relationshipType : this.classMap.getRelationshipType();
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public void validate() {
        if (this.srcField == null) {
            MappingUtils.throwMappingException("src field must be specified");
        }
        if (this.destField == null) {
            MappingUtils.throwMappingException("dest field must be specified");
        }
    }

    protected DozerPropertyDescriptorIF getSrcPropertyDescriptor(Class runtimeSrcClass) {
        return PropertyDescriptorFactory.getPropertyDescriptor(runtimeSrcClass, this.getSrcFieldTheGetMethod(), this.getSrcFieldTheSetMethod(), this.getSrcFieldMapGetMethod(), this.getSrcFieldMapSetMethod(), this.isSrcFieldAccessible(), this.isSrcFieldIndexed(), this.getSrcFieldIndex(), this.getSrcFieldName(), this.getSrcFieldKey(), this.isSrcSelfReferencing(), this.getDestFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.classMap.getSrcClassBeanFactory());
    }

    protected DozerPropertyDescriptorIF getDestPropertyDescriptor(Class runtimeDestClass) {
        return PropertyDescriptorFactory.getPropertyDescriptor(runtimeDestClass, this.getDestFieldTheGetMethod(), this.getDestFieldTheSetMethod(), this.getDestFieldMapGetMethod(), this.getDestFieldMapSetMethod(), this.isDestFieldAccessible(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getDestFieldName(), this.getDestFieldKey(), this.isDestSelfReferencing(), this.getSrcFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.classMap.getDestClassBeanFactory());
    }

    protected DozerField getSrcField() {
        return this.srcField;
    }

    protected DozerField getDestField() {
        return this.destField;
    }

    public String getCustomConverterId() {
        return this.customConverterId;
    }

    public void setCustomConverterId(String customConverterId) {
        this.customConverterId = customConverterId;
    }

    public boolean isRemoveOrphans() {
        return this.removeOrphans;
    }

    public void setRemoveOrphans(boolean removeOrphans) {
        this.removeOrphans = removeOrphans;
    }

    public boolean isDestMapNull() {
        return this.classMap.isDestMapNull();
    }

    public boolean isDestMapEmptyString() {
        return this.classMap.isDestMapEmptyString();
    }

    public boolean isTrimStrings() {
        return this.classMap.isTrimStrings();
    }

    public boolean isStopOnErrors() {
        return this.classMap.isStopOnErrors();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("source field", (Object)this.srcField).append("destination field", (Object)this.destField).append("type", (Object)this.type).append("customConverter", (Object)this.customConverter).append("relationshipType", (Object)this.relationshipType).append("removeOrphans", this.removeOrphans).append("mapId", (Object)this.mapId).append("copyByReference", this.copyByReference).append("copyByReferenceOveridden", this.copyByReferenceOveridden).append("srcTypeHint", (Object)this.srcHintContainer).append("destTypeHint", (Object)this.destHintContainer).toString();
    }
}

