/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.event;

import java.util.List;
import net.sf.dozer.util.mapping.event.DozerEvent;
import net.sf.dozer.util.mapping.event.DozerEventListener;
import net.sf.dozer.util.mapping.event.EventManagerIF;
import net.sf.dozer.util.mapping.util.MappingUtils;

public class DozerEventManager
implements EventManagerIF {
    private final List eventListeners;

    public DozerEventManager(List eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void fireEvent(DozerEvent event) {
        if (this.eventListeners == null) {
            return;
        }
        String eventType = event.getType();
        int size = this.eventListeners.size();
        for (int i = 0; i < size; ++i) {
            DozerEventListener listener = (DozerEventListener)this.eventListeners.get(i);
            if (eventType.equals("MAPPING_STARTED")) {
                listener.mappingStarted(event);
                continue;
            }
            if (eventType.equals("MAPPING_PRE_WRITING_DEST_VALUE")) {
                listener.preWritingDestinationValue(event);
                continue;
            }
            if (eventType.equals("MAPPING_POST_WRITING_DEST_VALUE")) {
                listener.postWritingDestinationValue(event);
                continue;
            }
            if (eventType.equals("MAPPING_FINISHED")) {
                listener.mappingFinished(event);
                continue;
            }
            MappingUtils.throwMappingException("Unsupported event type: " + eventType);
        }
    }
}

