/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.dozer.util.mapping.converters.CalendarConverter;
import net.sf.dozer.util.mapping.converters.ConversionException;
import net.sf.dozer.util.mapping.converters.DateConverter;
import net.sf.dozer.util.mapping.converters.IntegerConverter;
import net.sf.dozer.util.mapping.converters.LongConverter;
import net.sf.dozer.util.mapping.converters.StringConstructorConverter;
import net.sf.dozer.util.mapping.converters.StringConverter;
import net.sf.dozer.util.mapping.util.DateFormatContainer;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.ShortConverter;

public class PrimitiveOrWrapperConverter {
    private static final Map PRIMITIVE_TYPE_MAP = new HashMap();
    private static final Map CONVERTER_MAP = new HashMap();
    private static final Converter DEFAULT_CONVERTER = new StringConstructorConverter();

    public Object convert(Object srcFieldValue, Class destFieldClass, DateFormatContainer dateFormatContainer) {
        if (srcFieldValue == null || destFieldClass == null || srcFieldValue.equals("") && !destFieldClass.equals(String.class)) {
            return null;
        }
        Converter converter = this.getPrimitiveOrWrapperConverter(destFieldClass, dateFormatContainer);
        try {
            return converter.convert(destFieldClass, srcFieldValue);
        }
        catch (org.apache.commons.beanutils.ConversionException e) {
            throw new ConversionException(e);
        }
    }

    private Converter getPrimitiveOrWrapperConverter(Class destClass, DateFormatContainer dateFormatContainer) {
        if (String.class.equals(destClass)) {
            return new StringConverter(dateFormatContainer);
        }
        Converter result = (Converter)CONVERTER_MAP.get(destClass.isPrimitive() ? this.wrapPrimitive(destClass) : destClass);
        if (result == null) {
            if (Date.class.isAssignableFrom(destClass)) {
                result = new DateConverter(dateFormatContainer.getDateFormat());
            }
            if (Calendar.class.isAssignableFrom(destClass)) {
                result = new CalendarConverter(dateFormatContainer.getDateFormat());
            }
        }
        return result == null ? DEFAULT_CONVERTER : result;
    }

    private Class wrapPrimitive(Class c) {
        return (Class)PRIMITIVE_TYPE_MAP.get(c);
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        for (int i = 0; i < primitives.length; ++i) {
            PRIMITIVE_TYPE_MAP.put(primitives[i], wrappers[i]);
        }
        CONVERTER_MAP.put(Integer.class, new IntegerConverter());
        CONVERTER_MAP.put(Double.class, new DoubleConverter());
        CONVERTER_MAP.put(Short.class, new ShortConverter());
        CONVERTER_MAP.put(Character.class, new CharacterConverter());
        CONVERTER_MAP.put(Long.class, new LongConverter());
        CONVERTER_MAP.put(Boolean.class, new BooleanConverter());
        CONVERTER_MAP.put(Byte.class, new ByteConverter());
        CONVERTER_MAP.put(Float.class, new FloatConverter());
        CONVERTER_MAP.put(BigDecimal.class, new BigDecimalConverter());
        CONVERTER_MAP.put(BigInteger.class, new BigIntegerConverter());
    }
}

