/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.converters;

import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.sf.dozer.util.mapping.converters.ConversionException;
import org.apache.commons.beanutils.Converter;

public class DateConverter
implements Converter {
    private DateFormat dateFormat;

    public DateConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Object convert(Class destClass, Object srcObj) {
        Object result = null;
        Class<?> srcFieldClass = srcObj.getClass();
        long time = -1L;
        if (Calendar.class.isAssignableFrom(srcFieldClass)) {
            Calendar inVal = (Calendar)srcObj;
            time = inVal.getTime().getTime();
        } else if (Date.class.isAssignableFrom(srcFieldClass)) {
            time = ((Date)srcObj).getTime();
        } else {
            if (this.dateFormat != null && String.class.isAssignableFrom(srcObj.getClass())) {
                try {
                    if ("".equals(srcObj)) {
                        return null;
                    }
                    time = this.dateFormat.parse((String)srcObj).getTime();
                }
                catch (ParseException e) {
                    throw new ConversionException("Unable to parse source object using specified date format", e);
                }
            }
            try {
                time = Long.parseLong(srcObj.toString());
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to determine time in millis of source object", e);
            }
        }
        try {
            Constructor constructor = destClass.getConstructor(Long.TYPE);
            result = constructor.newInstance(new Long(time));
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        return result;
    }
}

