/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.converters;

import java.util.ArrayList;
import java.util.List;
import net.sf.dozer.util.mapping.cache.Cache;
import net.sf.dozer.util.mapping.cache.CacheEntry;
import net.sf.dozer.util.mapping.cache.CacheKeyFactory;
import net.sf.dozer.util.mapping.converters.CustomConverterDescription;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CustomConverterContainer {
    private List converters = new ArrayList();

    public List getConverters() {
        return this.converters;
    }

    public void setConverters(List converters) {
        this.converters = converters;
    }

    public void addConverter(CustomConverterDescription converter) {
        this.getConverters().add(converter);
    }

    public Class getCustomConverter(Class srcClass, Class destClass, Cache converterByDestTypeCache) {
        Object cacheKey;
        CacheEntry cacheEntry;
        Class c;
        Class dest;
        Class c2;
        if (this.converters == null || this.converters.size() < 1) {
            return null;
        }
        Class src = srcClass;
        if (srcClass.isPrimitive() && (c2 = this.getWrapper(srcClass)) != null) {
            src = c2;
        }
        if ((dest = destClass).isPrimitive() && (c = this.getWrapper(destClass)) != null) {
            dest = c;
        }
        if ((cacheEntry = converterByDestTypeCache.get(cacheKey = CacheKeyFactory.createKey(new Object[]{dest, src}))) != null) {
            return (Class)cacheEntry.getValue();
        }
        Class result = null;
        long size = this.converters.size();
        int i = 0;
        while ((long)i < size) {
            CustomConverterDescription customConverter = (CustomConverterDescription)this.converters.get(i);
            Class classA = customConverter.getClassA();
            Class classB = customConverter.getClassB();
            if (classA.isAssignableFrom(dest) && classB.isAssignableFrom(src) || classA.isAssignableFrom(src) && classB.isAssignableFrom(dest)) {
                result = customConverter.getType();
            }
            ++i;
        }
        cacheEntry = new CacheEntry(cacheKey, result);
        converterByDestTypeCache.put(cacheEntry);
        return result;
    }

    private Class getWrapper(Class c) {
        Class clazz = null;
        if (c.equals(Integer.TYPE)) {
            clazz = Integer.class;
        } else if (c.equals(Double.TYPE)) {
            clazz = Double.class;
        } else if (c.equals(Short.TYPE)) {
            clazz = Short.class;
        } else if (c.equals(Long.TYPE)) {
            clazz = Long.class;
        } else if (c.equals(Boolean.TYPE)) {
            clazz = Boolean.class;
        } else if (c.equals(Float.TYPE)) {
            clazz = Float.class;
        }
        return clazz;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

