/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.dozer.util.mapping.converters.ConversionException;
import org.apache.commons.beanutils.Converter;

public class CalendarConverter
implements Converter {
    private DateFormat dateFormat;

    public CalendarConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Object convert(Class destClass, Object srcObj) {
        Class<?> srcFieldClass;
        GregorianCalendar result = new GregorianCalendar();
        if (Date.class.isAssignableFrom(srcFieldClass = srcObj.getClass())) {
            result.setTime((Date)srcObj);
        } else if (Calendar.class.isAssignableFrom(srcFieldClass)) {
            Calendar c = (Calendar)srcObj;
            result.setTime(c.getTime());
            ((Calendar)result).setTimeZone(c.getTimeZone());
        } else {
            if (this.dateFormat != null && String.class.isAssignableFrom(srcFieldClass)) {
                try {
                    result.setTime(new Date(this.dateFormat.parse((String)srcObj).getTime()));
                }
                catch (ParseException e) {
                    throw new ConversionException("Unable to parse source object using specified date format", e);
                }
            }
            try {
                result.setTime(new Date(Long.parseLong(srcObj.toString())));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to determine time in millis of source object", e);
            }
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }
}

