/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.config;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.sf.dozer.util.mapping.util.InitLogger;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.ResourceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalSettings {
    private static final Log log = LogFactory.getLog((Class)GlobalSettings.class);
    private static GlobalSettings singleton;
    private String loadedByFileName;
    private boolean statisticsEnabled = false;
    private long converterByDestTypeCacheMaxSize = 5000L;
    private long superTypesCacheMaxSize = 5000L;
    private boolean autoregisterJMXBeans = true;
    private final boolean isJdk5 = System.getProperty("java.version", "1.4").startsWith("1.5") || System.getProperty("java.version", "1.4").startsWith("1.6");

    public static synchronized GlobalSettings getInstance() {
        if (singleton == null) {
            singleton = new GlobalSettings();
        }
        return singleton;
    }

    protected static GlobalSettings createNew() {
        return new GlobalSettings();
    }

    private GlobalSettings() {
        this.loadGlobalSettings();
    }

    protected String getLoadedByFileName() {
        return this.loadedByFileName;
    }

    public boolean isJava5() {
        return this.isJdk5;
    }

    public boolean isAutoregisterJMXBeans() {
        return this.autoregisterJMXBeans;
    }

    public long getConverterByDestTypeCacheMaxSize() {
        return this.converterByDestTypeCacheMaxSize;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public long getSuperTypesCacheMaxSize() {
        return this.superTypesCacheMaxSize;
    }

    private synchronized void loadGlobalSettings() {
        String propFileName = System.getProperty("dozer.configuration");
        if (MappingUtils.isBlankOrNull(propFileName)) {
            propFileName = "dozer.properties";
        }
        InitLogger.log(log, "Trying to find Dozer configuration file: " + propFileName);
        ResourceLoader loader = new ResourceLoader();
        URL url = loader.getResource(propFileName);
        if (url == null) {
            InitLogger.log(log, "Dozer configuration file not found: " + propFileName + ".  Using defaults for all Dozer global properties.");
            return;
        }
        InitLogger.log(log, "Using URL [" + url + "] for Dozer global property configuration");
        Properties props = new Properties();
        try {
            InitLogger.log(log, "Reading Dozer properties from URL [" + url + "]");
            props.load(url.openStream());
        }
        catch (IOException e) {
            MappingUtils.throwMappingException("Problem loading Dozer properties from URL [" + propFileName + "]", e);
        }
        String propValue = props.getProperty("dozer.statistics.enabled");
        if (propValue != null) {
            this.statisticsEnabled = Boolean.valueOf(propValue);
        }
        if ((propValue = props.getProperty("dozer.cache.converter.by.dest.type.maxsize")) != null) {
            this.converterByDestTypeCacheMaxSize = Long.parseLong(propValue);
        }
        if ((propValue = props.getProperty("dozer.cache.super.type.maxsize")) != null) {
            this.superTypesCacheMaxSize = Long.parseLong(propValue);
        }
        if ((propValue = props.getProperty("dozer.autoregister.jmx.beans")) != null) {
            this.autoregisterJMXBeans = Boolean.valueOf(propValue);
        }
        this.loadedByFileName = propFileName;
        InitLogger.log(log, "Finished configuring Dozer global properties");
    }
}

