/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.classmap;

import java.util.ArrayList;
import java.util.List;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.classmap.DozerClass;
import net.sf.dozer.util.mapping.converters.CustomConverterContainer;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ClassMap {
    private Configuration globalConfiguration;
    private DozerClass srcClass;
    private DozerClass destClass;
    private List fieldMaps = new ArrayList();
    private List allowedExceptions = new ArrayList();
    private String type;
    private String dateFormat;
    private String beanFactory;
    private boolean mapNull = true;
    private boolean mapEmptyString = true;
    private Boolean wildcard;
    private Boolean stopOnErrors;
    private Boolean trimStrings;
    private CustomConverterContainer customConverters;
    private String mapId;
    private String relationshipType;

    public ClassMap(Configuration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public List getFieldMaps() {
        return this.fieldMaps;
    }

    public boolean isStopOnErrors() {
        return this.stopOnErrors != null ? this.stopOnErrors.booleanValue() : this.globalConfiguration.getStopOnErrors().booleanValue();
    }

    public void setStopOnErrors(Boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    public boolean isTrimStrings() {
        return this.trimStrings != null ? this.trimStrings.booleanValue() : this.globalConfiguration.getTrimStrings().booleanValue();
    }

    public void setTrimStrings(Boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    public List getAllowedExceptions() {
        if (!this.allowedExceptions.isEmpty()) {
            return this.allowedExceptions;
        }
        return this.globalConfiguration.getAllowedExceptions() != null ? this.globalConfiguration.getAllowedExceptions().getExceptions() : this.allowedExceptions;
    }

    public void setAllowedExceptions(List allowedExceptions) {
        this.allowedExceptions = allowedExceptions;
    }

    public FieldMap getFieldMapUsingDest(String destFieldName) {
        FieldMap result = null;
        if (this.fieldMaps != null) {
            int size = this.fieldMaps.size();
            for (int i = 0; i < size; ++i) {
                FieldMap fieldMap = (FieldMap)this.fieldMaps.get(i);
                String fieldName = fieldMap.getDestFieldName();
                String alternateFieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
                if (!fieldName.equals(destFieldName) && !alternateFieldName.equals(destFieldName)) continue;
                result = fieldMap;
                break;
            }
        }
        return result;
    }

    public FieldMap getFieldMapUsingSrc(String srcFieldName) {
        FieldMap result = null;
        if (this.fieldMaps != null) {
            for (int i = 0; i < this.fieldMaps.size(); ++i) {
                FieldMap fieldMap = (FieldMap)this.fieldMaps.get(i);
                String fieldName = fieldMap.getSrcFieldName();
                if (fieldName == null || !fieldName.equals(srcFieldName)) continue;
                result = fieldMap;
                break;
            }
        }
        return result;
    }

    public void setFieldMaps(List fieldMaps) {
        this.fieldMaps = fieldMaps;
    }

    public void addFieldMapping(FieldMap fieldMap) {
        this.fieldMaps.add(fieldMap);
    }

    public void removeFieldMapping(FieldMap fieldMap) {
        this.fieldMaps.remove(fieldMap);
    }

    public boolean isWildcard() {
        return this.wildcard != null ? this.wildcard.booleanValue() : this.globalConfiguration.getWildcard().booleanValue();
    }

    public void setWildcard(Boolean wildcardPolicy) {
        this.wildcard = wildcardPolicy;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDateFormat() {
        return !MappingUtils.isBlankOrNull(this.dateFormat) ? this.dateFormat : this.globalConfiguration.getDateFormat();
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public CustomConverterContainer getCustomConverters() {
        return this.customConverters != null ? this.customConverters : this.globalConfiguration.getCustomConverters();
    }

    public void setCustomConverters(CustomConverterContainer customConverters) {
        this.customConverters = customConverters;
    }

    public Class getSrcClassToMap() {
        return this.srcClass.getClassToMap();
    }

    public Class getDestClassToMap() {
        return this.destClass.getClassToMap();
    }

    public boolean isDestMapNull() {
        return this.destClass.getMapNull() != null ? this.destClass.getMapNull() : this.mapNull;
    }

    public boolean isSrcMapNull() {
        return this.srcClass.getMapNull() != null ? this.srcClass.getMapNull() : this.mapNull;
    }

    public boolean isDestMapEmptyString() {
        return this.destClass.getMapEmptyString() != null ? this.destClass.getMapEmptyString() : this.mapEmptyString;
    }

    public boolean isSrcMapEmptyString() {
        return this.srcClass.getMapEmptyString() != null ? this.srcClass.getMapEmptyString() : this.mapEmptyString;
    }

    public String getDestClassBeanFactory() {
        return !MappingUtils.isBlankOrNull(this.destClass.getBeanFactory()) ? this.destClass.getBeanFactory() : this.getBeanFactory();
    }

    public String getSrcClassBeanFactory() {
        return !MappingUtils.isBlankOrNull(this.srcClass.getBeanFactory()) ? this.srcClass.getBeanFactory() : this.getBeanFactory();
    }

    public String getDestClassBeanFactoryId() {
        return this.destClass.getFactoryBeanId();
    }

    public String getSrcClassBeanFactoryId() {
        return this.srcClass.getFactoryBeanId();
    }

    public String getSrcClassMapGetMethod() {
        return this.srcClass.getMapGetMethod();
    }

    public String getSrcClassMapSetMethod() {
        return this.srcClass.getMapSetMethod();
    }

    public String getDestClassMapGetMethod() {
        return this.destClass.getMapGetMethod();
    }

    public String getDestClassMapSetMethod() {
        return this.destClass.getMapSetMethod();
    }

    public String getDestClassCreateMethod() {
        return this.destClass.getCreateMethod();
    }

    public String getSrcClassCreateMethod() {
        return this.srcClass.getCreateMethod();
    }

    public void setSrcClassCreateMethod(String createMethod) {
        this.srcClass.setCreateMethod(createMethod);
    }

    public void setDestClassCreateMethod(String createMethod) {
        this.destClass.setCreateMethod(createMethod);
    }

    public boolean isDestClassMapTypeCustomGetterSetter() {
        return this.destClass.isMapTypeCustomGetterSetterClass();
    }

    public boolean isSrcClassMapTypeCustomGetterSetter() {
        return this.srcClass.isMapTypeCustomGetterSetterClass();
    }

    public void setSrcClass(DozerClass srcClass) {
        this.srcClass = srcClass;
    }

    public void setDestClass(DozerClass destClass) {
        this.destClass = destClass;
    }

    public String getDestClassName() {
        return this.destClass.getName();
    }

    public String getSrcClassName() {
        return this.srcClass.getName();
    }

    public String getBeanFactory() {
        return !MappingUtils.isBlankOrNull(this.beanFactory) ? this.beanFactory : this.globalConfiguration.getBeanFactory();
    }

    public void setBeanFactory(String beanFactory) {
        this.beanFactory = beanFactory;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public void setMapNull(boolean mapNull) {
        this.mapNull = mapNull;
    }

    public void setMapEmptyString(boolean mapEmptyString) {
        this.mapEmptyString = mapEmptyString;
    }

    public Configuration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public String getRelationshipType() {
        return this.relationshipType != null ? this.relationshipType : this.globalConfiguration.getRelationshipType();
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("source class", (Object)this.getSrcClassName()).append("destination class", (Object)this.getDestClassName()).append("map-id", (Object)this.mapId).toString();
    }
}

