/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.cache.Cache;
import net.sf.dozer.util.mapping.cache.CacheManagerIF;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DozerCacheManager
implements CacheManagerIF {
    private static final Log log = LogFactory.getLog((Class)DozerCacheManager.class);
    private final Map cachesMap = new HashMap();

    public Set getCaches() {
        return new HashSet(this.cachesMap.values());
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.cachesMap.get(name);
        if (cache == null) {
            MappingUtils.throwMappingException("Unable to find cache with name: " + name);
        }
        return cache;
    }

    public void addCache(String name, long maxElementsInMemory) {
        this.addCache(new Cache(name, maxElementsInMemory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCache(Cache cache) {
        Map map = this.cachesMap;
        synchronized (map) {
            String name = cache.getName();
            if (this.cacheExists(name)) {
                MappingUtils.throwMappingException("Cache already exists with name: " + name);
            }
            this.cachesMap.put(name, cache);
        }
    }

    public Set getCacheNames() {
        HashSet results = new HashSet();
        Iterator iter = this.cachesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            results.add(entry.getKey());
        }
        return results;
    }

    public void clearAllEntries() {
        Iterator iter = this.cachesMap.values().iterator();
        while (iter.hasNext()) {
            Cache cache = (Cache)iter.next();
            cache.clear();
        }
    }

    public boolean cacheExists(String name) {
        return this.cachesMap.containsKey(name);
    }

    public void logCaches() {
        log.info((Object)this.getCaches());
    }
}

