/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.cache;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CacheEntry {
    private final Object key;
    private final Object value;
    private final long creationTime;

    public CacheEntry(Object key, Object value) {
        this.key = key;
        this.value = value;
        this.creationTime = System.currentTimeMillis();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CacheEntry)) {
            return false;
        }
        CacheEntry entry = (CacheEntry)object;
        return new EqualsBuilder().append(this.getKey(), entry.getKey()).isEquals();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

