/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping.cache;

import java.util.Collection;
import java.util.Map;
import net.sf.dozer.util.mapping.cache.CacheEntry;
import net.sf.dozer.util.mapping.stats.GlobalStatistics;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Cache {
    private final String name;
    private long maximumSize;
    private final Map cacheMap;
    private long hitCount;
    private long missCount;

    public Cache(String name, long maximumSize) {
        this.name = name;
        this.maximumSize = maximumSize;
        this.cacheMap = new CacheLinkedHashMap();
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public synchronized void put(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            throw new IllegalArgumentException("Cache Entry cannot be null");
        }
        this.cacheMap.put(cacheEntry.getKey(), cacheEntry);
        if ((long)this.cacheMap.size() > this.maximumSize) {
            ((LinkedMap)this.cacheMap).remove(this.cacheMap.size() - 1);
        }
    }

    public CacheEntry get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        CacheEntry result = (CacheEntry)this.cacheMap.get(key);
        StatisticsManagerIF statMgr = GlobalStatistics.getInstance().getStatsMgr();
        if (result != null) {
            ++this.hitCount;
            statMgr.increment("Cache Hit Count", this.name);
        } else {
            ++this.missCount;
            statMgr.increment("Cache Miss Count", this.name);
        }
        return result;
    }

    public Collection getEntries() {
        return this.cacheMap.values();
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.cacheMap.size();
    }

    public long getMaxSize() {
        return this.maximumSize;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    private class CacheLinkedHashMap
    extends LinkedMap {
        public CacheLinkedHashMap() {
            super(100, 0.75f);
        }
    }
}

