/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.CustomFieldMapperIF;
import net.sf.dozer.util.mapping.MapperIF;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.cache.Cache;
import net.sf.dozer.util.mapping.cache.CacheEntry;
import net.sf.dozer.util.mapping.cache.CacheKeyFactory;
import net.sf.dozer.util.mapping.cache.CacheManagerIF;
import net.sf.dozer.util.mapping.classmap.ClassMap;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.config.GlobalSettings;
import net.sf.dozer.util.mapping.converters.CustomConverter;
import net.sf.dozer.util.mapping.converters.PrimitiveOrWrapperConverter;
import net.sf.dozer.util.mapping.event.DozerEvent;
import net.sf.dozer.util.mapping.event.DozerEventManager;
import net.sf.dozer.util.mapping.event.EventManagerIF;
import net.sf.dozer.util.mapping.fieldmap.CustomGetSetMethodFieldMap;
import net.sf.dozer.util.mapping.fieldmap.ExcludeFieldMap;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.fieldmap.HintContainer;
import net.sf.dozer.util.mapping.fieldmap.MapFieldMap;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import net.sf.dozer.util.mapping.util.ClassMapBuilder;
import net.sf.dozer.util.mapping.util.ClassMapFinder;
import net.sf.dozer.util.mapping.util.ClassMapKeyFactory;
import net.sf.dozer.util.mapping.util.CollectionUtils;
import net.sf.dozer.util.mapping.util.DateFormatContainer;
import net.sf.dozer.util.mapping.util.DestBeanCreator;
import net.sf.dozer.util.mapping.util.Jdk5Methods;
import net.sf.dozer.util.mapping.util.LogMsgFactory;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.MappingValidator;
import net.sf.dozer.util.mapping.util.ReflectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MappingProcessor
implements MapperIF {
    private static final Log log = LogFactory.getLog((Class)MappingProcessor.class);
    private final Map customMappings;
    private final Configuration globalConfiguration;
    private final List customConverterObjects;
    private final Map customConverterObjectsWithId;
    private final StatisticsManagerIF statsMgr;
    private final EventManagerIF eventMgr;
    private final CustomFieldMapperIF customFieldMapper;
    private final Map mappedFields = new HashMap();
    private final Cache converterByDestTypeCache;
    private final Cache superTypeCache;
    private final PrimitiveOrWrapperConverter primitiveOrWrapperConverter = new PrimitiveOrWrapperConverter();

    protected MappingProcessor(Map customMappings, Configuration globalConfiguration, CacheManagerIF cacheMgr, StatisticsManagerIF statsMgr, List customConverterObjects, List eventListeners, CustomFieldMapperIF customFieldMapper, Map customConverterObjectsWithId) {
        this.customMappings = customMappings;
        this.globalConfiguration = globalConfiguration;
        this.statsMgr = statsMgr;
        this.customConverterObjects = customConverterObjects;
        this.eventMgr = new DozerEventManager(eventListeners);
        this.customFieldMapper = customFieldMapper;
        this.converterByDestTypeCache = cacheMgr.getCache("Converter By Destination Type Dozer Cache");
        this.superTypeCache = cacheMgr.getCache("Super Type Mapping Dozer Cache");
        this.customConverterObjectsWithId = customConverterObjectsWithId;
    }

    public Object map(Object srcObj, Class destClass) {
        return this.map(srcObj, destClass, (String)null);
    }

    public Object map(Object srcObj, Class destClass, String mapId) {
        MappingValidator.validateMappingRequest(srcObj, destClass);
        Object result = null;
        ClassMap classMap = null;
        try {
            classMap = this.getClassMap(srcObj, destClass, mapId);
            Class converterClass = MappingUtils.findCustomConverter(this.converterByDestTypeCache, classMap.getCustomConverters(), srcObj.getClass(), destClass);
            if (converterClass != null) {
                this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, srcObj, result, null));
                return this.mapUsingCustomConverter(converterClass, srcObj.getClass(), srcObj, destClass, result, null, true);
            }
            result = DestBeanCreator.create(srcObj, classMap.getSrcClassToMap(), classMap.getDestClassToMap(), destClass, classMap.getDestClassBeanFactory(), classMap.getDestClassBeanFactoryId(), classMap.getDestClassCreateMethod());
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, srcObj, result, null));
            this.map(classMap, srcObj, result, false, null);
        }
        catch (Throwable e) {
            MappingUtils.throwMappingException(e);
        }
        this.eventMgr.fireEvent(new DozerEvent("MAPPING_FINISHED", classMap, null, srcObj, result, null));
        return result;
    }

    public void map(Object srcObj, Object destObj) {
        this.map(srcObj, destObj, null);
    }

    public void map(Object srcObj, Object destObj, String mapId) {
        MappingValidator.validateMappingRequest(srcObj, destObj);
        ClassMap classMap = null;
        try {
            classMap = this.getClassMap(srcObj, destObj.getClass(), mapId);
            Class converterClass = MappingUtils.findCustomConverter(this.converterByDestTypeCache, classMap.getCustomConverters(), srcObj.getClass(), destObj.getClass());
            if (converterClass != null) {
                this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, srcObj, destObj, null));
                this.mapUsingCustomConverter(converterClass, srcObj.getClass(), srcObj, destObj.getClass(), destObj, null, true);
                return;
            }
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, srcObj, destObj, null));
            this.map(classMap, srcObj, destObj, false, null);
        }
        catch (Throwable e) {
            MappingUtils.throwMappingException(e);
        }
        this.eventMgr.fireEvent(new DozerEvent("MAPPING_FINISHED", classMap, null, srcObj, destObj, null));
    }

    private void map(ClassMap classMap, Object srcObj, Object destObj, boolean bypassSuperMappings, String mapId) {
        this.mappedFields.put(srcObj, destObj);
        if (classMap == null) {
            classMap = this.getClassMap(srcObj, destObj.getClass(), mapId);
        }
        Class<?> srcClass = srcObj.getClass();
        Class<?> destClass = destObj.getClass();
        Class converterClass = MappingUtils.findCustomConverter(this.converterByDestTypeCache, classMap.getCustomConverters(), srcClass, destClass);
        if (converterClass != null) {
            this.mapUsingCustomConverter(converterClass, srcClass, srcObj, destClass, destObj, null, true);
            return;
        }
        List mappedParentFields = null;
        if (!bypassSuperMappings) {
            Set superClasses = this.checkForSuperTypeMapping(srcClass, destClass);
            superClasses.addAll(ClassMapFinder.findInterfaceMappings(this.customMappings, srcClass, destClass));
            if (superClasses.size() > 0) {
                mappedParentFields = this.processSuperTypeMapping(superClasses, srcObj, destObj, mapId);
            }
        }
        List fieldMaps = classMap.getFieldMaps();
        int size = fieldMaps.size();
        for (int i = 0; i < size; ++i) {
            FieldMap fieldMapping = (FieldMap)fieldMaps.get(i);
            String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMapping.getDestFieldName());
            if (mappedParentFields != null && mappedParentFields.contains(key)) continue;
            this.mapField(fieldMapping, srcObj, destObj);
        }
    }

    private void mapField(FieldMap fieldMapping, Object srcObj, Object destObj) {
        if (fieldMapping instanceof ExcludeFieldMap) {
            return;
        }
        Object srcFieldValue = null;
        try {
            srcFieldValue = fieldMapping.getSrcFieldValue(srcObj);
            boolean fieldMapped = false;
            if (this.customFieldMapper != null) {
                fieldMapped = this.customFieldMapper.mapField(srcObj, destObj, srcFieldValue, fieldMapping.getClassMap(), fieldMapping);
            }
            if (!fieldMapped) {
                if (fieldMapping.getDestFieldType() != null && fieldMapping.getDestFieldType().equals("iterate")) {
                    this.mapFromIterateMethodFieldMap(srcObj, destObj, srcFieldValue, fieldMapping);
                } else {
                    this.mapFromFieldMap(srcObj, destObj, srcFieldValue, fieldMapping);
                }
            }
            this.statsMgr.increment("Field Mapping Success Count");
        }
        catch (Throwable e) {
            log.error((Object)LogMsgFactory.createFieldMappingErrorMsg(srcObj, fieldMapping, srcFieldValue, destObj, e), e);
            this.statsMgr.increment("Field Mapping Failure Count");
            if (fieldMapping.isStopOnErrors()) {
                MappingUtils.throwMappingException(e);
            }
            if (!fieldMapping.getClassMap().getAllowedExceptions().isEmpty() && e.getCause() instanceof InvocationTargetException) {
                Throwable thrownType = ((InvocationTargetException)e.getCause()).getTargetException();
                Class<?> exceptionClass = thrownType.getClass();
                if (fieldMapping.getClassMap().getAllowedExceptions().contains(exceptionClass)) {
                    throw (RuntimeException)thrownType;
                }
            }
            this.statsMgr.increment("Field Mapping Failure Ignored Count");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapFromFieldMap(Object srcObj, Object destObj, Object srcFieldValue, FieldMap fieldMapping) {
        Class<?> destFieldType = null;
        if (fieldMapping instanceof CustomGetSetMethodFieldMap) {
            try {
                destFieldType = fieldMapping.getDestFieldWriteMethod(destObj.getClass()).getParameterTypes()[0];
            }
            catch (Throwable e) {
                destFieldType = fieldMapping.getDestFieldType(destObj.getClass());
            }
        } else {
            destFieldType = fieldMapping.getDestFieldType(destObj.getClass());
        }
        Object destFieldValue = null;
        if (!MappingUtils.isBlankOrNull(fieldMapping.getCustomConverterId())) {
            if (this.customConverterObjectsWithId == null || !this.customConverterObjectsWithId.containsKey(fieldMapping.getCustomConverterId())) throw new MappingException("CustomConverter instance not found with id:" + fieldMapping.getCustomConverterId());
            Class srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            destFieldValue = this.mapUsingCustomConverterInstance(this.customConverterObjectsWithId.get(fieldMapping.getCustomConverterId()), srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMapping, false);
        } else if (MappingUtils.isBlankOrNull(fieldMapping.getCustomConverter())) {
            destFieldValue = this.mapOrRecurseObject(srcObj, srcFieldValue, destFieldType, fieldMapping, destObj);
        } else {
            Class srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            destFieldValue = this.mapUsingCustomConverter(MappingUtils.loadClass(fieldMapping.getCustomConverter()), srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMapping, false);
        }
        this.writeDestinationValue(destObj, destFieldValue, fieldMapping, srcObj);
        if (!log.isDebugEnabled()) return;
        log.debug((Object)LogMsgFactory.createFieldMappingSuccessMsg(srcObj.getClass(), destObj.getClass(), fieldMapping.getSrcFieldName(), fieldMapping.getDestFieldName(), srcFieldValue, destFieldValue, fieldMapping.getClassMap().getMapId()));
    }

    private Object mapOrRecurseObject(Object srcObj, Object srcFieldValue, Class destFieldType, FieldMap fieldMap, Object destObj) {
        Class srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMap.getSrcFieldType(srcObj.getClass());
        Class converterClass = MappingUtils.determineCustomConverter(fieldMap, this.converterByDestTypeCache, fieldMap.getClassMap().getCustomConverters(), srcFieldClass, destFieldType);
        if (converterClass != null) {
            return this.mapUsingCustomConverter(converterClass, srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMap, false);
        }
        if (srcFieldValue == null) {
            return null;
        }
        Object alreadyMappedValue = null;
        if (srcFieldValue != null) {
            alreadyMappedValue = this.mappedFields.get(srcFieldValue);
        }
        if (alreadyMappedValue != null) {
            if (destFieldType.isAssignableFrom(alreadyMappedValue.getClass())) {
                return alreadyMappedValue;
            }
            if (destFieldType.isInterface() && destFieldType.isAssignableFrom(alreadyMappedValue.getClass())) {
                return alreadyMappedValue;
            }
        }
        if (fieldMap.isCopyByReference()) {
            return srcFieldValue;
        }
        boolean isSrcFieldClassSupportedMap = MappingUtils.isSupportedMap(srcFieldClass);
        boolean isDestFieldTypeSupportedMap = MappingUtils.isSupportedMap(destFieldType);
        if (isSrcFieldClassSupportedMap && isDestFieldTypeSupportedMap) {
            return this.mapMap(srcObj, srcFieldValue, fieldMap, destObj);
        }
        if (fieldMap instanceof MapFieldMap && destFieldType.equals(Object.class)) {
            Class clazz = destFieldType = fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : srcFieldClass;
        }
        if (MappingUtils.isPrimitiveOrWrapper(srcFieldClass) || MappingUtils.isPrimitiveOrWrapper(destFieldType)) {
            if (fieldMap.getDestHintContainer() != null) {
                destFieldType = fieldMap.getDestHintContainer().getHint();
            }
            DateFormatContainer dfContainer = new DateFormatContainer(fieldMap.getDateFormat());
            Object convertSrcFieldValue = srcFieldValue;
            if (srcFieldValue != null && fieldMap.isTrimStrings() && srcFieldValue.getClass().equals(String.class)) {
                convertSrcFieldValue = ((String)srcFieldValue).trim();
            }
            if (fieldMap instanceof MapFieldMap && !MappingUtils.isPrimitiveOrWrapper(destFieldType)) {
                return this.primitiveOrWrapperConverter.convert(convertSrcFieldValue, convertSrcFieldValue.getClass(), dfContainer);
            }
            return this.primitiveOrWrapperConverter.convert(convertSrcFieldValue, destFieldType, dfContainer);
        }
        if (MappingUtils.isSupportedCollection(srcFieldClass) && MappingUtils.isSupportedCollection(destFieldType)) {
            return this.mapCollection(srcObj, srcFieldValue, fieldMap, destObj);
        }
        if (GlobalSettings.getInstance().isJava5() && ((Boolean)ReflectionUtils.invoke(Jdk5Methods.getInstance().getClassIsEnumMethod(), srcFieldClass, null)).booleanValue() && ((Boolean)ReflectionUtils.invoke(Jdk5Methods.getInstance().getClassIsEnumMethod(), destFieldType, null)).booleanValue()) {
            return this.mapEnum(srcFieldValue, destFieldType);
        }
        return this.mapCustomObject(fieldMap, destObj, destFieldType, srcFieldValue);
    }

    private Object mapEnum(Object srcFieldValue, Class destFieldType) {
        String name = (String)ReflectionUtils.invoke(Jdk5Methods.getInstance().getEnumNameMethod(), srcFieldValue, null);
        return ReflectionUtils.invoke(Jdk5Methods.getInstance().getEnumValueOfMethod(), destFieldType, new Object[]{destFieldType, name});
    }

    private Object mapCustomObject(FieldMap fieldMap, Object destObj, Class destFieldType, Object srcFieldValue) {
        Object result = MappingProcessor.getExistingValue(fieldMap, destObj, destFieldType);
        ClassMap classMap = null;
        if (result == null) {
            Class destHintType;
            if (fieldMap.getDestHintContainer() != null && (destHintType = fieldMap.getDestHintContainer().getHint()) != null) {
                destFieldType = destHintType;
            }
            String mapId = fieldMap.getMapId();
            classMap = this.getClassMap(srcFieldValue, destFieldType, mapId);
            result = DestBeanCreator.create(srcFieldValue, classMap.getSrcClassToMap(), fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : classMap.getDestClassToMap(), destFieldType, classMap.getDestClassBeanFactory(), classMap.getDestClassBeanFactoryId(), fieldMap.getDestFieldCreateMethod() != null ? fieldMap.getDestFieldCreateMethod() : classMap.getDestClassCreateMethod());
        }
        this.map(classMap, srcFieldValue, result, false, fieldMap.getMapId());
        return result;
    }

    private Object mapCollection(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj) {
        if (fieldMap.getDestHintContainer() == null && GlobalSettings.getInstance().isJava5()) {
            Class genericType = null;
            try {
                Method method = fieldMap.getDestFieldWriteMethod(destObj.getClass());
                genericType = ReflectionUtils.determineGenericsType(method, false);
            }
            catch (Throwable e) {
                log.info((Object)("The destObj:" + destObj + " does not have a write method"));
            }
            if (genericType != null) {
                HintContainer destHintContainer = new HintContainer();
                destHintContainer.setHintName(genericType.getName());
                fieldMap.setDestHintContainer(destHintContainer);
            }
        }
        if (srcCollectionValue instanceof Iterator) {
            srcCollectionValue = IteratorUtils.toList((Iterator)((Iterator)srcCollectionValue));
        }
        Class destCollectionType = fieldMap.getDestFieldType(destObj.getClass());
        Class<?> srcFieldType = srcCollectionValue.getClass();
        Object result = null;
        if (destCollectionType.getName().equals(Collection.class.getName())) {
            Class clazz = destCollectionType = List.class;
        }
        if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapArrayToArray(srcObj, srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapArrayToList(srcObj, srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isList(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapListToArray(srcObj, (List)srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isList(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapListToList(srcObj, (List)srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isSet(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapSetToArray(srcObj, (Set)srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(srcObj, fieldMap, Arrays.asList((Object[])srcCollectionValue), destObj);
        } else if (CollectionUtils.isSet(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapListToList(srcObj, (Set)srcCollectionValue, fieldMap, destObj);
        } else if (CollectionUtils.isCollection(srcFieldType) && CollectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(srcObj, fieldMap, (Collection)srcCollectionValue, destObj);
        }
        return result;
    }

    private Object mapMap(Object srcObj, Object srcMapValue, FieldMap fieldMap, Object destObj) {
        Map result = null;
        Object field = fieldMap.getDestValue(destObj);
        result = field == null ? (Map)DestBeanCreator.create(srcMapValue.getClass()) : (Map)field;
        Map srcMap = (Map)srcMapValue;
        Set srcEntrySet = srcMap.entrySet();
        Iterator iter = srcEntrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry srcEntry = iter.next();
            Object srcEntryValue = srcEntry.getValue();
            Object destEntryValue = this.mapOrRecurseObject(srcObj, srcEntryValue, srcEntryValue.getClass(), fieldMap, destObj);
            Object obj = result.get(srcEntry.getKey());
            if (obj != null && obj.equals(destEntryValue) && "non-cumulative".equals(fieldMap.getRelationshipType())) {
                this.map(null, srcEntryValue, obj, false, null);
                continue;
            }
            result.put(srcEntry.getKey(), destEntryValue);
        }
        return result;
    }

    private Object mapArrayToArray(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj) {
        Class<?> destEntryType = fieldMap.getDestFieldType(destObj.getClass()).getComponentType();
        int size = Array.getLength(srcCollectionValue);
        if (CollectionUtils.isPrimitiveArray(srcCollectionValue.getClass())) {
            return this.addToPrimitiveArray(srcObj, fieldMap, size, srcCollectionValue, destObj, destEntryType);
        }
        List<Object> list = Arrays.asList((Object[])srcCollectionValue);
        List returnList = null;
        returnList = !destEntryType.getName().equals("java.lang.Object") ? this.addOrUpdateToList(srcObj, fieldMap, list, destObj, destEntryType) : this.addOrUpdateToList(srcObj, fieldMap, list, destObj, null);
        return CollectionUtils.convertListToArray(returnList, destEntryType);
    }

    private void mapFromIterateMethodFieldMap(Object srcObj, Object destObj, Object srcFieldValue, FieldMap fieldMapping) {
        if (srcFieldValue instanceof Iterator) {
            srcFieldValue = IteratorUtils.toList((Iterator)((Iterator)srcFieldValue));
        }
        if (srcFieldValue != null) {
            for (int i = 0; i < CollectionUtils.getLengthOfCollection(srcFieldValue); ++i) {
                Class converterClass;
                Object value = CollectionUtils.getValueFromCollection(srcFieldValue, i);
                if (fieldMapping.getDestHintContainer() == null) {
                    MappingUtils.throwMappingException("<field type=\"iterate\"> must have a source or destination type hint");
                }
                if ((converterClass = MappingUtils.findCustomConverter(this.converterByDestTypeCache, fieldMapping.getClassMap().getCustomConverters(), value.getClass(), fieldMapping.getDestHintContainer().getHint())) != null) {
                    Class<?> srcFieldClass = srcFieldValue.getClass();
                    value = this.mapUsingCustomConverter(converterClass, srcFieldClass, value, fieldMapping.getDestHintContainer().getHint(), null, fieldMapping, false);
                } else {
                    value = this.map(value, fieldMapping.getDestHintContainer().getHint());
                }
                if (value == null) continue;
                this.writeDestinationValue(destObj, value, fieldMapping, srcObj);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogMsgFactory.createFieldMappingSuccessMsg(srcObj.getClass(), destObj.getClass(), fieldMapping.getSrcFieldName(), fieldMapping.getDestFieldName(), srcFieldValue, null, fieldMapping.getClassMap().getMapId()));
        }
    }

    private Object addToPrimitiveArray(Object srcObj, FieldMap fieldMap, int size, Object srcCollectionValue, Object destObj, Class destEntryType) {
        int i;
        Object result = null;
        Object field = fieldMap.getDestValue(destObj);
        int arraySize = 0;
        if (field == null) {
            result = Array.newInstance(destEntryType, size);
        } else {
            result = Array.newInstance(destEntryType, size + Array.getLength(field));
            arraySize = Array.getLength(field);
            for (i = 0; i < Array.getLength(field); ++i) {
                Array.set(result, i, Array.get(field, i));
            }
        }
        for (i = 0; i < size; ++i) {
            Object toValue = this.mapOrRecurseObject(srcObj, Array.get(srcCollectionValue, i), destEntryType, fieldMap, destObj);
            Array.set(result, arraySize, toValue);
            ++arraySize;
        }
        return result;
    }

    private Object mapListToArray(Object srcObj, Collection srcCollectionValue, FieldMap fieldMap, Object destObj) {
        List list = null;
        Class<?> destEntryType = fieldMap.getDestFieldType(destObj.getClass()).getComponentType();
        list = !destEntryType.getName().equals("java.lang.Object") ? this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, destEntryType) : this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj);
        return CollectionUtils.convertListToArray(list, destEntryType);
    }

    private List mapListToList(Object srcObj, Collection srcCollectionValue, FieldMap fieldMap, Object destObj) {
        return this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj);
    }

    private Set addToSet(Object srcObj, FieldMap fieldMap, Collection srcCollectionValue, Object destObj) {
        ArrayList<Object> mappedElements = new ArrayList<Object>();
        Class destEntryType = null;
        ListOrderedSet result = new ListOrderedSet();
        Object field = fieldMap.getDestValue(destObj);
        if (field != null) {
            result.addAll((Collection)field);
        }
        Object destValue = null;
        Iterator iter = srcCollectionValue.iterator();
        Object srcValue = null;
        while (iter.hasNext()) {
            srcValue = iter.next();
            if (destEntryType == null || fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destEntryType = fieldMap.getDestHintType(srcValue.getClass());
            }
            destValue = this.mapOrRecurseObject(srcObj, srcValue, destEntryType, fieldMap, destObj);
            if (fieldMap.getRelationshipType() == null || fieldMap.getRelationshipType().equals("cumulative")) {
                result.add(destValue);
                mappedElements.add(destValue);
                continue;
            }
            if (result.contains(destValue)) {
                int index = result.indexOf(destValue);
                Object obj = result.get(index);
                if (obj.getClass().isAssignableFrom(class$java$lang$String == null ? MappingProcessor.class$("java.lang.String") : class$java$lang$String)) continue;
                this.map(null, srcValue, obj, false, null);
                mappedElements.add(obj);
                continue;
            }
            result.add(destValue);
            mappedElements.add(destValue);
        }
        if (fieldMap.isRemoveOrphans()) {
            result.clear();
            result.addAll(mappedElements);
        }
        if (field == null) {
            Class destSetType = fieldMap.getDestFieldType(destObj.getClass());
            return CollectionUtils.createNewSet(destSetType, (Collection)result);
        }
        ((Set)field).clear();
        ((Set)field).addAll(result);
        return (Set)field;
    }

    private List addOrUpdateToList(Object srcObj, FieldMap fieldMap, Collection srcCollectionValue, Object destObj, Class destEntryType) {
        HashSet<Object> mappedElements = new HashSet<Object>();
        List<Object> result = null;
        Object field = fieldMap.getDestValue(destObj);
        result = field == null ? new ArrayList(srcCollectionValue.size()) : (CollectionUtils.isList(field.getClass()) ? (List)field : (CollectionUtils.isArray(field.getClass()) ? new ArrayList<Object>(Arrays.asList((Object[])field)) : new ArrayList(srcCollectionValue.size())));
        Object destValue = null;
        Iterator iter = srcCollectionValue.iterator();
        Object srcValue = null;
        Class prevDestEntryType = null;
        while (iter.hasNext()) {
            srcValue = iter.next();
            if (destEntryType == null || fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destEntryType = srcValue == null ? prevDestEntryType : fieldMap.getDestHintType(srcValue.getClass());
            }
            destValue = this.mapOrRecurseObject(srcObj, srcValue, destEntryType, fieldMap, destObj);
            prevDestEntryType = destEntryType;
            if (fieldMap.getRelationshipType() == null || fieldMap.getRelationshipType().equals("cumulative")) {
                result.add(destValue);
                mappedElements.add(destValue);
                continue;
            }
            if (result.contains(destValue)) {
                int index = result.indexOf(destValue);
                Object obj = result.get(index);
                if (obj.getClass().isAssignableFrom(class$java$lang$String == null ? MappingProcessor.class$("java.lang.String") : class$java$lang$String)) continue;
                this.map(null, srcValue, obj, false, null);
                mappedElements.add(obj);
                continue;
            }
            result.add(destValue);
            mappedElements.add(destValue);
        }
        if (fieldMap.isRemoveOrphans()) {
            result.clear();
            result.addAll(mappedElements);
        }
        return result;
    }

    private List addOrUpdateToList(Object srcObj, FieldMap fieldMap, Collection srcCollectionValue, Object destObj) {
        return this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, null);
    }

    private Object mapSetToArray(Object srcObj, Collection srcCollectionValue, FieldMap fieldMap, Object destObj) {
        return this.mapListToArray(srcObj, srcCollectionValue, fieldMap, destObj);
    }

    private List mapArrayToList(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj) {
        Class<?> destEntryType = null;
        destEntryType = fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : srcCollectionValue.getClass().getComponentType();
        List<Object> srcValueList = null;
        srcValueList = CollectionUtils.isPrimitiveArray(srcCollectionValue.getClass()) ? CollectionUtils.convertPrimitiveArrayToList(srcCollectionValue) : Arrays.asList((Object[])srcCollectionValue);
        return this.addOrUpdateToList(srcObj, fieldMap, srcValueList, destObj, destEntryType);
    }

    private void writeDestinationValue(Object destObj, Object destFieldValue, FieldMap fieldMap, Object srcObj) {
        boolean bypass = false;
        if (destFieldValue == null && !fieldMap.isDestMapNull()) {
            bypass = true;
        }
        if (destFieldValue != null && !fieldMap.isDestMapEmptyString() && destFieldValue.getClass().equals(String.class) && StringUtils.isEmpty((String)((String)destFieldValue))) {
            bypass = true;
        }
        if (destFieldValue != null && fieldMap.isTrimStrings() && destFieldValue.getClass().equals(String.class)) {
            destFieldValue = ((String)destFieldValue).trim();
        }
        if (!bypass) {
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_PRE_WRITING_DEST_VALUE", fieldMap.getClassMap(), fieldMap, srcObj, destObj, destFieldValue));
            fieldMap.writeDestValue(destObj, destFieldValue);
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_POST_WRITING_DEST_VALUE", fieldMap.getClassMap(), fieldMap, srcObj, destObj, destFieldValue));
        }
    }

    private Object mapUsingCustomConverterInstance(Object converterInstance, Class srcFieldClass, Object srcFieldValue, Class destFieldClass, Object existingDestFieldValue, FieldMap fieldMap, boolean topLevel) {
        if (!(converterInstance instanceof CustomConverter)) {
            MappingUtils.throwMappingException("Custom Converter does not implement CustomConverter interface");
        }
        if (srcFieldValue == null && !fieldMap.isDestMapNull()) {
            return null;
        }
        CustomConverter theConverter = (CustomConverter)converterInstance;
        Object result = null;
        long start = System.currentTimeMillis();
        if (topLevel) {
            result = theConverter.convert(existingDestFieldValue, srcFieldValue, destFieldClass, srcFieldClass);
        } else {
            Object existingValue = MappingProcessor.getExistingValue(fieldMap, existingDestFieldValue, destFieldClass);
            result = theConverter.convert(existingValue, srcFieldValue, destFieldClass, srcFieldClass);
        }
        long stop = System.currentTimeMillis();
        this.statsMgr.increment("Custom Converter Success Count");
        this.statsMgr.increment("Custom Converter Overall Time(ms)", stop - start);
        return result;
    }

    private Object mapUsingCustomConverter(Class customConverterClass, Class srcFieldClass, Object srcFieldValue, Class destFieldClass, Object existingDestFieldValue, FieldMap fieldMap, boolean topLevel) {
        Object converterInstance = null;
        if (this.customConverterObjects != null) {
            for (int i = 0; i < this.customConverterObjects.size(); ++i) {
                Object customConverter = this.customConverterObjects.get(i);
                if (!customConverter.getClass().isAssignableFrom(customConverterClass)) continue;
                converterInstance = customConverter;
            }
        }
        if (converterInstance == null) {
            converterInstance = ReflectionUtils.newInstance(customConverterClass);
        }
        return this.mapUsingCustomConverterInstance(converterInstance, srcFieldClass, srcFieldValue, destFieldClass, existingDestFieldValue, fieldMap, topLevel);
    }

    private Set checkForSuperTypeMapping(Class srcClass, Class destClass) {
        Object cacheKey = CacheKeyFactory.createKey(new Object[]{destClass, srcClass});
        CacheEntry cacheEntry = this.superTypeCache.get(cacheKey);
        if (cacheEntry != null) {
            return (Set)cacheEntry.getValue();
        }
        HashSet<ClassMap> superClasses = new HashSet<ClassMap>();
        Class superSrcClass = MappingUtils.getRealSuperclass(srcClass);
        Class superDestClass = MappingUtils.getRealSuperclass(destClass);
        boolean stillHasSuperClasses = true;
        while (stillHasSuperClasses && (superSrcClass != null && !superSrcClass.getName().equals("java.lang.Object") || superDestClass != null && !superDestClass.getName().equals("java.lang.Object"))) {
            ClassMap superClassMap = (ClassMap)this.customMappings.get(ClassMapKeyFactory.createKey(superSrcClass, destClass));
            if (superClassMap != null) {
                superClasses.add(superClassMap);
            }
            boolean stillHasDestSuperClasses = true;
            while (stillHasDestSuperClasses && superDestClass != null && !superDestClass.getName().equals("java.lang.Object")) {
                ClassMap srcClassMap;
                ClassMap superDestClassMap = (ClassMap)this.customMappings.get(ClassMapKeyFactory.createKey(superSrcClass, superDestClass));
                if (superDestClassMap != null) {
                    superClasses.add(superDestClassMap);
                }
                if ((srcClassMap = (ClassMap)this.customMappings.get(ClassMapKeyFactory.createKey(srcClass, superDestClass))) != null) {
                    superClasses.add(srcClassMap);
                }
                superDestClass = MappingUtils.getRealSuperclass(superDestClass);
            }
            superSrcClass = MappingUtils.getRealSuperclass(superSrcClass);
        }
        cacheEntry = new CacheEntry(cacheKey, superClasses);
        this.superTypeCache.put(cacheEntry);
        return superClasses;
    }

    private List processSuperTypeMapping(Set superClasses, Object srcObj, Object destObj, String mapId) {
        ArrayList<String> mappedFields = new ArrayList<String>();
        Object[] superClassArray = superClasses.toArray();
        for (int a = 0; a < superClassArray.length; ++a) {
            ClassMap map = (ClassMap)superClassArray[a];
            this.map(map, srcObj, destObj, true, mapId);
            List fieldMaps = map.getFieldMaps();
            for (int i = 0; i < fieldMaps.size(); ++i) {
                FieldMap fieldMapping = (FieldMap)fieldMaps.get(i);
                String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMapping.getDestFieldName());
                mappedFields.add(key);
            }
        }
        return mappedFields;
    }

    private static Object getExistingValue(FieldMap fieldMap, Object destObj, Class destFieldType) {
        Object result = null;
        if (destObj == null) {
            return null;
        }
        result = fieldMap.getDestValue(destObj);
        if (result != null && (CollectionUtils.isList(result.getClass()) || CollectionUtils.isArray(result.getClass()) || CollectionUtils.isSet(result.getClass()) || MappingUtils.isSupportedMap(result.getClass())) && !CollectionUtils.isList(destFieldType) && !CollectionUtils.isArray(destFieldType) && !CollectionUtils.isSet(destFieldType) && !MappingUtils.isSupportedMap(destFieldType)) {
            result = null;
        }
        return result;
    }

    private ClassMap getClassMap(Object srcObj, Class destClass, String mapId) {
        ClassMap mapping = ClassMapFinder.findClassMap(this.customMappings, srcObj.getClass(), destClass, mapId);
        if (mapping == null) {
            if (!MappingUtils.isBlankOrNull(mapId)) {
                MappingUtils.throwMappingException("Class mapping not found for map-id: " + mapId);
            }
            mapping = ClassMapBuilder.createDefaultClassMap(this.globalConfiguration, srcObj.getClass(), destClass);
            this.customMappings.put(ClassMapKeyFactory.createKey(srcObj.getClass(), destClass), mapping);
        }
        return mapping;
    }
}

