/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dozer.util.mapping;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import net.sf.dozer.util.mapping.CustomFieldMapperIF;
import net.sf.dozer.util.mapping.DozerInitializer;
import net.sf.dozer.util.mapping.MapperIF;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.MappingProcessor;
import net.sf.dozer.util.mapping.cache.CacheManagerIF;
import net.sf.dozer.util.mapping.cache.DozerCacheManager;
import net.sf.dozer.util.mapping.classmap.Configuration;
import net.sf.dozer.util.mapping.config.GlobalSettings;
import net.sf.dozer.util.mapping.interceptor.StatisticsInterceptor;
import net.sf.dozer.util.mapping.stats.GlobalStatistics;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import net.sf.dozer.util.mapping.util.CustomMappingsLoader;
import net.sf.dozer.util.mapping.util.InitLogger;
import net.sf.dozer.util.mapping.util.LoadMappingsResult;
import net.sf.dozer.util.mapping.util.MappingUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DozerBeanMapper
implements MapperIF {
    private static final Log log = LogFactory.getLog((Class)DozerBeanMapper.class);
    private static final StatisticsManagerIF statsMgr = GlobalStatistics.getInstance().getStatsMgr();
    private List mappingFiles;
    private List customConverters;
    private List eventListeners;
    private CustomFieldMapperIF customFieldMapper;
    private Map customConvertersWithId;
    private Map customMappings;
    private Configuration globalConfiguration;
    private final CacheManagerIF cacheManager = new DozerCacheManager();

    public DozerBeanMapper() {
        this(null);
    }

    public DozerBeanMapper(List mappingFiles) {
        this.mappingFiles = mappingFiles;
        this.init();
    }

    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    public Object map(Object source, Class destinationClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    public Object map(Object source, Class destinationClass) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass);
    }

    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    public List getMappingFiles() {
        return this.mappingFiles;
    }

    public void setMappingFiles(List mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public void setFactories(Map factories) {
        MappingUtils.storedFactories.putAll(factories);
    }

    public void setCustomConverters(List customConverters) {
        this.customConverters = customConverters;
    }

    private void init() {
        InitLogger.log(log, "Initializing a new instance of the dozer bean mapper.");
        this.cacheManager.addCache("Converter By Destination Type Dozer Cache", GlobalSettings.getInstance().getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache("Super Type Mapping Dozer Cache", GlobalSettings.getInstance().getSuperTypesCacheMaxSize());
        statsMgr.increment("Mapper Instances Count");
    }

    protected MapperIF getMappingProcessor() {
        if (this.customMappings == null) {
            this.loadCustomMappings();
        }
        MapperIF processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, statsMgr, this.customConverters, this.getEventListeners(), this.getCustomFieldMapper(), this.customConvertersWithId);
        if (statsMgr.isStatisticsEnabled()) {
            processor = (MapperIF)Proxy.newProxyInstance(processor.getClass().getClassLoader(), processor.getClass().getInterfaces(), (InvocationHandler)new StatisticsInterceptor(processor, statsMgr));
        }
        return processor;
    }

    private synchronized void loadCustomMappings() {
        if (this.customMappings == null) {
            CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader();
            LoadMappingsResult loadMappingsResult = customMappingsLoader.load(this.mappingFiles);
            this.customMappings = loadMappingsResult.getCustomMappings();
            this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
        }
    }

    public List getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List eventListeners) {
        this.eventListeners = eventListeners;
    }

    public CustomFieldMapperIF getCustomFieldMapper() {
        return this.customFieldMapper;
    }

    public void setCustomFieldMapper(CustomFieldMapperIF customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
    }

    public Map getCustomConvertersWithId() {
        return this.customConvertersWithId;
    }

    public void setCustomConvertersWithId(Map customConvertersWithId) {
        this.customConvertersWithId = customConvertersWithId;
    }

    static {
        DozerInitializer.init();
    }
}

