/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.CoinDispenserControl18;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.CoinDispenserService12;
import jpos.services.CoinDispenserService13;
import jpos.services.CoinDispenserService14;
import jpos.services.CoinDispenserService15;
import jpos.services.CoinDispenserService16;
import jpos.services.CoinDispenserService17;
import jpos.services.CoinDispenserService18;
import jpos.services.EventCallbacks;

public class CoinDispenser
extends BaseJposControl
implements CoinDispenserControl18,
JposConst {
    protected CoinDispenserService12 service12;
    protected CoinDispenserService13 service13;
    protected CoinDispenserService14 service14;
    protected CoinDispenserService15 service15;
    protected CoinDispenserService16 service16;
    protected CoinDispenserService17 service17;
    protected CoinDispenserService18 service18;
    protected Vector directIOListeners;
    protected Vector statusUpdateListeners;

    public CoinDispenser() {
        this.deviceControlDescription = "JavaPOS CoinDispenser Device Control";
        this.deviceControlVersion = 1008000;
        this.directIOListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapEmptySensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapEmptySensor();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapJamSensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapJamSensor();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapNearEmptySensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapNearEmptySensor();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDispenserStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDispenserStatus();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void dispenseChange(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.dispenseChange(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new CoinDispenserCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (CoinDispenserService12)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService12 interface", exception);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (CoinDispenserService13)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService13 interface", exception);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (CoinDispenserService14)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService14 interface", exception);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (CoinDispenserService15)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService15 interface", exception);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (CoinDispenserService16)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService16 interface", exception);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (CoinDispenserService17)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService17 interface", exception);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (CoinDispenserService18)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService18 interface", exception);
                }
            }
        }
    }

    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class CoinDispenserCallbacks
    implements EventCallbacks {
        protected CoinDispenserCallbacks() {
        }

        public BaseControl getEventSource() {
            return CoinDispenser.this;
        }

        public void fireDataEvent(DataEvent dataEvent) {
        }

        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = CoinDispenser.this.directIOListeners;
            synchronized (vector) {
                int n = 0;
                while (n < CoinDispenser.this.directIOListeners.size()) {
                    ((DirectIOListener)CoinDispenser.this.directIOListeners.elementAt(n)).directIOOccurred(directIOEvent);
                    ++n;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent errorEvent) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = CoinDispenser.this.statusUpdateListeners;
            synchronized (vector) {
                int n = 0;
                while (n < CoinDispenser.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)CoinDispenser.this.statusUpdateListeners.elementAt(n)).statusUpdateOccurred(statusUpdateEvent);
                    ++n;
                }
            }
        }
    }
}

