/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyFrame;
import org.python.core.PyObject;

public class PyTraceback
extends PyObject {
    public PyObject tb_next;
    public PyFrame tb_frame;
    public int tb_lineno;

    private final String line() {
        if (this.tb_frame == null || this.tb_frame.f_code == null) {
            return "  (no code object) at line " + this.tb_lineno + "\n";
        }
        return "  File \"" + this.tb_frame.f_code.co_filename + "\", line " + this.tb_lineno + ", in " + this.tb_frame.f_code.co_name + "\n";
    }

    public void dumpStack(StringBuffer buf) {
        buf.append(this.line());
        if (this.tb_next != Py.None && this.tb_next != this) {
            ((PyTraceback)this.tb_next).dumpStack(buf);
        } else if (this.tb_next == this) {
            buf.append("circularity detected!" + this + this.tb_next);
        }
    }

    public String dumpStack() {
        StringBuffer buf = new StringBuffer();
        buf.append("Traceback (innermost last):\n");
        this.dumpStack(buf);
        return buf.toString();
    }

    public String toString() {
        return "<traceback object at " + this.hashCode() + ">";
    }

    public PyTraceback(PyFrame frame) {
        this.tb_frame = frame;
        if (this.tb_frame != null) {
            this.tb_lineno = this.tb_frame.getline();
        }
        this.tb_next = Py.None;
    }

    public PyTraceback(PyTraceback next) {
        this.tb_next = next;
        if (next != null) {
            this.tb_frame = next.tb_frame.f_back;
            this.tb_lineno = this.tb_frame.getline();
        }
    }
}

