/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.common.PDPageLabelRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDPageLabels
implements COSObjectable {
    private SortedMap<Integer, PDPageLabelRange> labels = new TreeMap<Integer, PDPageLabelRange>();
    private PDDocument doc;

    public PDPageLabels(PDDocument document) {
        this.doc = document;
        PDPageLabelRange defaultRange = new PDPageLabelRange();
        defaultRange.setStyle("D");
        this.labels.put(0, defaultRange);
    }

    public PDPageLabels(PDDocument document, COSDictionary dict) throws IOException {
        this(document);
        if (dict == null) {
            return;
        }
        PDNumberTreeNode root = new PDNumberTreeNode(dict, COSDictionary.class);
        this.findLabels(root);
    }

    private void findLabels(PDNumberTreeNode node) throws IOException {
        block3: {
            block2: {
                if (node.getKids() == null) break block2;
                List kids = node.getKids();
                for (PDNumberTreeNode kid : kids) {
                    this.findLabels(kid);
                }
                break block3;
            }
            if (node.getNumbers() == null) break block3;
            Map numbers = node.getNumbers();
            for (Map.Entry i : numbers.entrySet()) {
                if ((Integer)i.getKey() < 0) continue;
                this.labels.put((Integer)i.getKey(), new PDPageLabelRange((COSDictionary)i.getValue()));
            }
        }
    }

    public int getPageRangeCount() {
        return this.labels.size();
    }

    public PDPageLabelRange getPageLabelRange(int startPage) {
        return (PDPageLabelRange)this.labels.get(startPage);
    }

    public void setLabelItem(int startPage, PDPageLabelRange item) {
        this.labels.put(startPage, item);
    }

    @Override
    public COSBase getCOSObject() {
        COSDictionary dict = new COSDictionary();
        COSArray arr = new COSArray();
        for (Map.Entry<Integer, PDPageLabelRange> i : this.labels.entrySet()) {
            arr.add(COSInteger.get(i.getKey().intValue()));
            arr.add(i.getValue());
        }
        dict.setItem("Nums", (COSBase)arr);
        return dict;
    }

    public Map<String, Integer> getPageIndicesByLabels() {
        final HashMap<String, Integer> labelMap = new HashMap<String, Integer>(this.doc.getNumberOfPages());
        this.computeLabels(new LabelHandler(){

            public void newLabel(int pageIndex, String label) {
                labelMap.put(label, pageIndex);
            }
        });
        return labelMap;
    }

    public String[] getLabelsByPageIndices() {
        final String[] map = new String[this.doc.getNumberOfPages()];
        this.computeLabels(new LabelHandler(){

            public void newLabel(int pageIndex, String label) {
                map[pageIndex] = label;
            }
        });
        return map;
    }

    private void computeLabels(LabelHandler handler) {
        Iterator<Map.Entry<Integer, PDPageLabelRange>> iterator = this.labels.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        int pageIndex = 0;
        Map.Entry<Integer, PDPageLabelRange> lastEntry = iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PDPageLabelRange> entry = iterator.next();
            int numPages = entry.getKey() - lastEntry.getKey();
            LabelGenerator gen = new LabelGenerator(lastEntry.getValue(), numPages);
            while (gen.hasNext()) {
                handler.newLabel(pageIndex, gen.next());
                ++pageIndex;
            }
            lastEntry = entry;
        }
        LabelGenerator gen = new LabelGenerator(lastEntry.getValue(), this.doc.getNumberOfPages() - lastEntry.getKey());
        while (gen.hasNext()) {
            handler.newLabel(pageIndex, gen.next());
            ++pageIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelGenerator
    implements Iterator<String> {
        private PDPageLabelRange labelInfo;
        private int numPages;
        private int currentPage;
        private static final String[][] ROMANS = new String[][]{{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"}, {"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"}, {"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"}};

        public LabelGenerator(PDPageLabelRange label, int pages) {
            this.labelInfo = label;
            this.numPages = pages;
            this.currentPage = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentPage < this.numPages;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder buf = new StringBuilder();
            if (this.labelInfo.getPrefix() != null) {
                buf.append(this.labelInfo.getPrefix());
            }
            if (this.labelInfo.getStyle() != null) {
                buf.append(this.getNumber(this.labelInfo.getStart() + this.currentPage, this.labelInfo.getStyle()));
            }
            ++this.currentPage;
            return buf.toString();
        }

        private String getNumber(int pageIndex, String style) {
            if ("D".equals(style)) {
                return Integer.toString(pageIndex);
            }
            if ("a".equals(style)) {
                return LabelGenerator.makeLetterLabel(pageIndex);
            }
            if ("A".equals(style)) {
                return LabelGenerator.makeLetterLabel(pageIndex).toUpperCase();
            }
            if ("r".equals(style)) {
                return LabelGenerator.makeRomanLabel(pageIndex);
            }
            if ("R".equals(style)) {
                return LabelGenerator.makeRomanLabel(pageIndex).toUpperCase();
            }
            return Integer.toString(pageIndex);
        }

        private static String makeRomanLabel(int pageIndex) {
            StringBuilder buf = new StringBuilder();
            for (int power = 0; power < 3 && pageIndex > 0; pageIndex /= 10, ++power) {
                buf.insert(0, ROMANS[power][pageIndex % 10]);
            }
            for (int i = 0; i < pageIndex; ++i) {
                buf.insert(0, 'm');
            }
            return buf.toString();
        }

        private static String makeLetterLabel(int num) {
            StringBuilder buf = new StringBuilder();
            int numLetters = num / 26 + Integer.signum(num % 26);
            int letter = num % 26 + 26 * (1 - Integer.signum(num % 26)) + 64;
            for (int i = 0; i < numLetters; ++i) {
                buf.appendCodePoint(letter);
            }
            return buf.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface LabelHandler {
        public void newLabel(int var1, String var2);
    }
}

