/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SecureManager {
    private static final Logger LOGGER = Logger.getLogger(SecureManager.class.getName());
    private final SSLContext _context;

    /*
     * Exception decompiling
     */
    public SecureManager() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SecureSession createSession(InputStream in, OutputStream out) throws IOException {
        SSLEngine engine = this._context.createSSLEngine();
        return new SecureSession(engine, in, out);
    }

    public class SecureSession {
        private final SSLEngine _engine;
        private final InputStream _netIn;
        private final OutputStream _netOut;
        private final InputStream _appIn;
        private final OutputStream _appOut;
        private static final int BUFFER_SIZE = 65536;

        private SecureSession(SSLEngine engine, InputStream netIn, OutputStream netOut) throws IOException {
            this._engine = engine;
            this._engine.setEnableSessionCreation(true);
            this._engine.setUseClientMode(false);
            this._engine.setNeedClientAuth(false);
            this._engine.setWantClientAuth(false);
            this._netIn = netIn;
            this._netOut = netOut;
            this.handShake();
            this._appIn = new SecureInputStream();
            this._appOut = new SecureOutputStream();
        }

        public InputStream getInputStream() {
            return this._appIn;
        }

        public OutputStream getOutputStream() {
            return this._appOut;
        }

        private void closing() {
            try {
                int bufferSize = 65536;
                ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
                SSLEngineResult result = this._engine.wrap(ByteBuffer.wrap(new byte[0]), buffer);
                if (result.bytesProduced() != 0) {
                    this._netOut.write(buffer.array(), 0, result.bytesProduced());
                }
            }
            catch (IOException e) {
                LOGGER.warning("\u305f\u3076\u3093\u9589\u3058\u3066\u305f");
            }
        }

        private void handShake() throws IOException {
            byte[] netData = new byte[65536];
            block20: while (true) {
                SSLEngineResult result;
                int netDataSize = this._netIn.read(netData);
                ByteBuffer netDataBuffer = ByteBuffer.wrap(netData, 0, netDataSize);
                ByteBuffer appDataBuffer = ByteBuffer.allocate(65536);
                block21: while (true) {
                    result = this._engine.unwrap(netDataBuffer, appDataBuffer);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            System.out.println("overflow");
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            System.out.println("underflow");
                        }
                    }
                    switch (result.getHandshakeStatus()) {
                        case NEED_TASK: {
                            this.doDelegatedTask();
                            continue block21;
                        }
                        case NEED_WRAP: {
                            break block21;
                        }
                        case NOT_HANDSHAKING: {
                            return;
                        }
                        case FINISHED: {
                            return;
                        }
                        default: {
                            continue block21;
                        }
                    }
                    break;
                }
                netDataBuffer.clear();
                block22: while (true) {
                    result = this._engine.wrap(ByteBuffer.wrap(new byte[0]), netDataBuffer);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            System.out.println("overflow");
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            System.out.println("underflow");
                        }
                    }
                    if (result.bytesProduced() != 0) {
                        this._netOut.write(netDataBuffer.array(), 0, result.bytesProduced());
                        this._netOut.flush();
                        netDataBuffer.clear();
                    }
                    switch (result.getHandshakeStatus()) {
                        case NEED_TASK: {
                            this.doDelegatedTask();
                            continue block22;
                        }
                        case NEED_UNWRAP: {
                            continue block20;
                        }
                        case NOT_HANDSHAKING: {
                            return;
                        }
                        case FINISHED: {
                            return;
                        }
                    }
                }
                break;
            }
        }

        private void doDelegatedTask() {
            Runnable task;
            while ((task = this._engine.getDelegatedTask()) != null) {
                task.run();
            }
        }

        private class SecureInputStream
        extends InputStream {
            private ByteBuffer _inBuffer;
            private boolean _isClosed;

            public SecureInputStream() throws IOException {
                this._inBuffer = ByteBuffer.allocate(SecureSession.this._engine.getSession().getApplicationBufferSize());
                this._isClosed = false;
                this.readNetData();
            }

            @Override
            public int read() throws IOException {
                LOGGER.entering(SecureInputStream.class.getName(), "read");
                int ret = 0;
                if (this._inBuffer.remaining() == 0) {
                    if (this._isClosed) {
                        ret = -1;
                    } else {
                        this.readNetData();
                        ret = this.read();
                    }
                } else {
                    ret = this._inBuffer.get();
                }
                LOGGER.exiting(SecureInputStream.class.getName(), "read", ret);
                return ret;
            }

            @Override
            public void close() throws IOException {
                LOGGER.entering(SecureInputStream.class.getName(), "close");
                SecureSession.this._engine.isInboundDone();
                LOGGER.exiting(SecureInputStream.class.getName(), "close");
            }

            private void readNetData() throws IOException {
                byte[] netData = new byte[SecureSession.this._engine.getSession().getPacketBufferSize()];
                int netDataSize = SecureSession.this._netIn.read(netData);
                ByteBuffer netDataBuffer = ByteBuffer.wrap(netData, 0, netDataSize);
                this._inBuffer.clear();
                int totalReadSize = 0;
                block6: while (true) {
                    SSLEngineResult result = SecureSession.this._engine.unwrap(netDataBuffer, this._inBuffer);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            System.out.println("overflow");
                            this._inBuffer = ByteBuffer.allocate(SecureSession.this._engine.getSession().getApplicationBufferSize());
                            continue block6;
                        }
                        case BUFFER_UNDERFLOW: {
                            System.out.println("underflow");
                            continue block6;
                        }
                        case OK: {
                            if (netDataSize != (totalReadSize += result.bytesConsumed())) continue block6;
                            break block6;
                        }
                        case CLOSED: {
                            SecureSession.this.closing();
                            if (!SecureSession.this._engine.isInboundDone()) break block6;
                            this._isClosed = true;
                            break block6;
                        }
                        default: {
                            continue block6;
                        }
                    }
                    break;
                }
                this._inBuffer.limit(this._inBuffer.position());
                this._inBuffer.position(0);
            }
        }

        private class SecureOutputStream
        extends ByteArrayOutputStream {
            private SecureOutputStream() {
            }

            @Override
            public void flush() throws IOException {
                LOGGER.entering(SecureOutputStream.class.getName(), "flush");
                byte[] rawAppData = this.toByteArray();
                ByteBuffer appData = ByteBuffer.wrap(rawAppData);
                int netDataSize = 65536;
                int totalDataSize = 0;
                block5: while (true) {
                    ByteBuffer netData = ByteBuffer.allocate(netDataSize);
                    SSLEngineResult result = SecureSession.this._engine.wrap(appData, netData);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            netDataSize *= 2;
                            continue block5;
                        }
                        case BUFFER_UNDERFLOW: {
                            System.out.println("underflow : \uff1c\u8d77\u3053\u308a\u3048\u306a\u3044\uff1e");
                            assert (false);
                            continue block5;
                        }
                        case OK: {
                            if (result.bytesProduced() != 0) {
                                SecureSession.this._netOut.write(netData.array(), 0, result.bytesProduced());
                                SecureSession.this._netOut.flush();
                            }
                            if ((totalDataSize += result.bytesConsumed()) != rawAppData.length) continue block5;
                            break block5;
                        }
                        default: {
                            continue block5;
                        }
                    }
                    break;
                }
                this.reset();
                LOGGER.exiting(SecureOutputStream.class.getName(), "flush");
            }

            @Override
            public void close() throws IOException {
                LOGGER.entering(SecureOutputStream.class.getName(), "close");
                SecureSession.this._engine.isInboundDone();
                LOGGER.exiting(SecureOutputStream.class.getName(), "close");
            }
        }
    }
}

