/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import nor.util.log.EasyLogger;

class SocketChannelOutputStream
extends OutputStream {
    private final SelectionKey key;
    private final ByteBuffer buffer;
    private int timeout = 1000;
    private boolean alive = true;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(SocketChannelOutputStream.class);

    public SocketChannelOutputStream(SelectionKey key) {
        this.key = key;
        this.buffer = ByteBuffer.allocate(65536);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.alive) {
            while (this.available() == 0) {
                this.flush();
            }
            try {
                this.buffer.put((byte)b);
            }
            catch (BufferOverflowException e) {
                LOGGER.severe(String.valueOf(e.getMessage()) + " pos " + this.buffer.position() + ", lim " + this.buffer.limit() + ", cap " + this.buffer.capacity());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block3: {
            if (!this.alive) break block3;
            ** GOTO lbl17
            {
                this.flush();
                do {
                    if (this.available() == 0) continue block0;
                    size = this.available();
                    if (len > size) {
                        this.buffer.put(b, off, size);
                        off += size;
                        len -= size;
                        continue;
                    }
                    this.buffer.put(b, off, len);
                    off += len;
                    len -= len;
lbl17:
                    // 3 sources

                } while (len != 0);
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.alive) {
            try {
                this.key.interestOps(this.key.interestOps() | 4);
                this.key.selector().wakeup();
                this.wait(this.timeout);
            }
            catch (InterruptedException e) {
                this.alive = false;
                LOGGER.warning(e.getMessage());
                throw new IOException(e);
            }
            catch (CancelledKeyException e) {
                this.alive = false;
                LOGGER.throwing("flush", e);
                throw new IOException(e);
            }
            if (!this.alive) {
                throw new IOException("Connection is closed");
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public synchronized int storeToChannel(WritableByteChannel channel) {
        int ret = -1;
        try {
            try {
                this.buffer.flip();
                ret = channel.write(this.buffer);
                this.buffer.clear();
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
            catch (IOException e) {
                this.alive = false;
                LOGGER.throwing("storeToChannel", e);
                this.notify();
            }
        }
        finally {
            this.notify();
        }
        return ret;
    }

    private int available() throws IOException {
        return this.buffer.limit() - this.buffer.position();
    }
}

