/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import nor.util.log.EasyLogger;

class SocketChannelInputStream
extends InputStream {
    private final SelectionKey key;
    private final ByteBuffer buffer;
    private boolean closed = false;
    private int timeout = 1000;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(SocketChannelInputStream.class);

    public SocketChannelInputStream(SelectionKey key) {
        this.key = key;
        this.buffer = ByteBuffer.allocate(65536);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.available() == 0) {
            this.load();
            if (this.available() == 0) {
                return -1;
            }
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int available;
        if (this.closed) {
            return -1;
        }
        if (this.available() == 0) {
            this.load();
            if (this.available() == 0) {
                return -1;
            }
        }
        if (len > (available = this.available())) {
            this.buffer.get(b, off, available);
            return available;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.limit() - this.buffer.position();
    }

    @Override
    public void close() throws IOException {
        if (this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
        }
    }

    public synchronized int loadFromChannel(ReadableByteChannel channel) {
        int ret;
        block5: {
            LOGGER.entering("loadFromChannel", channel);
            ret = -1;
            try {
                try {
                    this.buffer.clear();
                    ret = channel.read(this.buffer);
                    this.buffer.flip();
                    this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
                }
                catch (IOException e) {
                    LOGGER.throwing("loadFromChannel", e);
                    this.notify();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.notify();
                throw throwable;
            }
            this.notify();
        }
        LOGGER.exiting("loadFromChannel", ret);
        return ret;
    }

    private synchronized void load() {
        LOGGER.entering("load", new Object[0]);
        try {
            this.key.interestOps(this.key.interestOps() | 1);
            this.key.selector().wakeup();
            this.wait(this.timeout);
        }
        catch (InterruptedException e) {
            LOGGER.throwing("load", e);
        }
        catch (CancelledKeyException e) {
            LOGGER.throwing("load", e);
        }
        LOGGER.exiting("load");
    }
}

