/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import nor.http.server.nserver.SocketChannelInputStream;
import nor.http.server.nserver.SocketChannelOutputStream;

class Connection
implements Closeable {
    private final SelectionKey key;
    private final SocketChannelInputStream in;
    private final SocketChannelOutputStream out;
    private final SocketChannel schannel;

    public Connection(SocketChannel schannel, Selector selector) throws IOException {
        this.schannel = schannel;
        this.schannel.configureBlocking(false);
        this.key = this.schannel.register(selector, 0);
        this.key.attach(this);
        this.in = new SocketChannelInputStream(this.key);
        this.out = new SocketChannelOutputStream(this.key);
    }

    public int loadFromChannel() {
        return this.in.loadFromChannel(this.schannel);
    }

    public int storeToChannel() {
        return this.out.storeToChannel(this.schannel);
    }

    @Override
    public void close() throws IOException {
        Selector selector = this.key.selector();
        this.key.attach(null);
        this.key.channel().close();
        this.key.cancel();
        selector.wakeup();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public String toString() {
        return String.format("Connection from the %s", this.schannel.socket());
    }
}

