/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.core.proxy.CharsetDetectingInputStream;
import nor.core.proxy.FilterRegisterImpl;
import nor.core.proxy.FilteringByteInputStream;
import nor.core.proxy.FilteringCharacterInputStream;
import nor.core.proxy.filter.EditingByteFilter;
import nor.core.proxy.filter.EditingStringFilter;
import nor.core.proxy.filter.MessageFilter;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.ReadonlyByteFilter;
import nor.core.proxy.filter.ReadonlyStringFilter;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.ResponseFilter;
import nor.http.HeaderName;
import nor.http.HttpBody;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.HttpRequestHandler;
import nor.http.server.proxyserver.ProxyRequestHandler;
import nor.util.log.EasyLogger;

class ProxyHandler
implements HttpRequestHandler {
    private final Collection<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
    private final Collection<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();
    private final Collection<MessageHandler> handlers = new ArrayList<MessageHandler>();
    private final ProxyRequestHandler proxyHandler;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ProxyHandler.class);

    public ProxyHandler(String name, String version) {
        LOGGER.entering("<init>", name, version);
        assert (name != null);
        assert (version != null);
        this.proxyHandler = new ProxyRequestHandler(name, version);
        LOGGER.exiting("<init>");
    }

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering("doRequest", request);
        assert (request != null);
        HttpResponse response = null;
        ProxyHandler.doFiltering(request, this.requestFilters);
        String path = request.getPath();
        for (MessageHandler h : this.handlers) {
            Matcher url = h.getHandlingURL().matcher(path);
            if (url.find() && (response = h.doRequest(request, url)) != null) break;
        }
        if (response == null) {
            response = this.proxyHandler.doRequest(request);
        }
        assert (response != null);
        ProxyHandler.doFiltering(response, this.responseFilters);
        LOGGER.exiting("doRequest", response);
        return response;
    }

    public void attach(MessageHandler handler) {
        LOGGER.entering("attach", handler);
        if (handler != null) {
            this.handlers.add(handler);
        }
        LOGGER.exiting("attach");
    }

    public void detach(MessageHandler handler) {
        LOGGER.entering("detach", handler);
        if (handler != null) {
            this.handlers.remove(handler);
        }
        LOGGER.exiting("detach");
    }

    public void attach(RequestFilter filter) {
        LOGGER.entering("attach", filter);
        if (filter != null) {
            this.requestFilters.add(filter);
        }
        LOGGER.exiting("attach");
    }

    public void detach(RequestFilter filter) {
        LOGGER.entering("detach", filter);
        if (filter != null) {
            this.requestFilters.remove(filter);
        }
        LOGGER.exiting("detach");
    }

    public void attach(ResponseFilter filter) {
        LOGGER.entering("attach", filter);
        if (filter != null) {
            this.responseFilters.add(filter);
        }
        LOGGER.exiting("attach");
    }

    public void detach(ResponseFilter filter) {
        LOGGER.entering("detach", filter);
        if (filter != null) {
            this.responseFilters.remove(filter);
        }
        LOGGER.exiting("detach");
    }

    public void addRouting(Pattern pat, URL extProxyHost) {
        LOGGER.entering("setExternalProxy", pat, extProxyHost);
        assert (pat != null);
        assert (extProxyHost != null);
        this.proxyHandler.addRouting(pat, extProxyHost);
        LOGGER.exiting("setExternalProxy");
    }

    public void removeRouting(Pattern pat) {
        LOGGER.entering("removeExternalProxy", pat);
        assert (pat != null);
        this.proxyHandler.removeRouting(pat);
        LOGGER.exiting("removeExternalProxy");
    }

    private static <Message extends HttpMessage, Filter extends MessageFilter<Message>> void doFiltering(Message msg, Collection<Filter> filters) {
        Pattern pat;
        Matcher m;
        Charset charset = null;
        HttpHeader header = msg.getHeader();
        if (header.containsKey(HeaderName.ContentType) && (m = (pat = Pattern.compile("charset=(\\S+)")).matcher(header.get(HeaderName.ContentType))).find()) {
            try {
                charset = Charset.forName(m.group(1).toLowerCase());
            }
            catch (UnsupportedCharsetException e) {
                LOGGER.warning(e.getMessage());
            }
        }
        FilterRegisterImpl register = new FilterRegisterImpl();
        String path = msg.getPath();
        for (MessageFilter f : filters) {
            if (header.containsKey("x-nor-nofilter")) break;
            Matcher url = f.getFilteringURL().matcher(path);
            if (!url.find()) continue;
            if (header.containsKey(HeaderName.ContentType)) {
                Matcher cType = f.getFilteringContentType().matcher(header.get(HeaderName.ContentType));
                if (!cType.find()) continue;
                f.update(msg, url, cType, register);
                continue;
            }
            f.update(msg, url, null, register);
        }
        HttpBody body = msg.getBody();
        InputStream in = body.getStream();
        List<EditingByteFilter> editingByteFilters = register.getEditingByteFilters();
        List<ReadonlyByteFilter> readonlyByteFilters = register.getReadonlyByteFilters();
        if (editingByteFilters.size() != 0 || readonlyByteFilters.size() != 0) {
            in = new FilteringByteInputStream(body.getStream(), editingByteFilters, readonlyByteFilters);
        }
        List<EditingStringFilter> editingStringFilters = register.getEditingStringFilters();
        List<ReadonlyStringFilter> readonlyStringFilters = register.getReadonlyStringFilters();
        if (editingStringFilters.size() != 0 || readonlyStringFilters.size() != 0) {
            String ctype;
            if (charset == null && header.containsKey(HeaderName.ContentType) && ((ctype = header.get(HeaderName.ContentType)).contains("html") || ctype.contains("xml"))) {
                CharsetDetectingInputStream cin = new CharsetDetectingInputStream(in);
                charset = cin.getCharset();
                in = cin;
            }
            in = new FilteringCharacterInputStream(in, charset, editingStringFilters, readonlyStringFilters);
            if (header.containsKey(HeaderName.ContentLength)) {
                header.set("x-nor-old-content-length", header.get(HeaderName.ContentLength));
                header.remove(HeaderName.ContentLength);
                header.add(HeaderName.TransferEncoding, "chunked");
                header.set(HeaderName.ContentEncoding, "gzip");
            }
        }
        msg.getBody().setStream(in);
        if (header.containsKey(HeaderName.ContentLength)) {
            if (!register.readonly()) {
                header.set("x-nor-old-content-length", header.get(HeaderName.ContentLength));
                header.remove(HeaderName.ContentLength);
                header.set(HeaderName.TransferEncoding, "chunked");
                header.set(HeaderName.ContentEncoding, "gzip");
            }
            if (header.containsKey(HeaderName.ContentEncoding)) {
                header.set("x-nor-old-content-length", header.get(HeaderName.ContentLength));
                header.remove(HeaderName.ContentLength);
                header.add(HeaderName.TransferEncoding, "chunked");
            }
        }
    }
}

