/*
 * Decompiled with CFR 0.152.
 */
package nor.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import nor.core.Config;
import nor.core.Context;
import nor.core.plugin.Plugin;
import nor.core.proxy.ProxyServer;
import nor.util.log.EasyLogger;

public class Nor {
    private static Nor instance;
    private ProxyServer proxy;
    private final File confDir;
    private final Config config;
    private final Context context = new Context();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private static final EasyLogger LOGGER;

    static {
        LOGGER = EasyLogger.getLogger(Nor.class);
    }

    private Nor() {
        LOGGER.entering("<init>", new Object[0]);
        this.confDir = new File(String.format("./config/%s/", this.context.getMAC()));
        if (!this.confDir.exists()) {
            this.confDir.mkdirs();
        }
        this.config = new Config(new File(this.confDir, String.valueOf(this.getClass().getCanonicalName()) + ".conf"));
        LOGGER.exiting("<init>");
    }

    private void init() {
        LOGGER.entering("init", new Object[0]);
        this.proxy = new ProxyServer(Nor.class.getSimpleName());
        for (Plugin p : ServiceLoader.load(Plugin.class)) {
            if (!this.config.isEnable(p)) continue;
            p.load(this.confDir);
            this.proxy.attach(p);
            this.plugins.add(p);
        }
        LOGGER.exiting("init");
    }

    private void loadPlugin(String classname) throws IllegalArgumentException {
        LOGGER.entering("loadPlugin", classname);
        try {
            Class<?> c = Class.forName(classname);
            Plugin p = (Plugin)c.newInstance();
            p.load(this.confDir);
            this.proxy.attach(p);
            this.plugins.add(p);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning(e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            LOGGER.warning(e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warning(e.getMessage());
            throw new IllegalArgumentException(e);
        }
        LOGGER.exiting("loadPlugin");
    }

    private void start() throws IOException {
        LOGGER.entering("start", new Object[0]);
        this.proxy.start(this.config.getListenAddress(), this.config.getListenPort());
        LOGGER.exiting("start");
    }

    private void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.proxy.close();
        for (Plugin p : this.plugins) {
            p.close();
            p.save(this.confDir);
        }
        this.config.store();
        LOGGER.exiting("close");
    }

    public static Nor instance() {
        LOGGER.entering(Nor.class.getName(), "getInstance");
        Nor ret = instance;
        LOGGER.exiting(Nor.class.getName(), "getInstance", ret);
        return ret;
    }

    private static Nor create() {
        LOGGER.entering("create", new Object[0]);
        instance = new Nor();
        LOGGER.exiting("create", instance);
        return instance;
    }

    public static void main(String[] args) throws MalformedURLException {
        LOGGER.entering("main", args);
        if (System.getProperty("java.util.logging.config.file") == null) {
            System.setProperty("java.util.logging.config.file", "logging.properties");
        }
        Nor nor = Nor.create();
        nor.init();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-r") && ++i != args.length) {
                nor.proxy.addRouting(Pattern.compile(".*"), new URL(args[i]));
            } else if (args[i].equals("-p") && ++i != args.length) {
                String[] stringArray = args[i].split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String classname = stringArray[n2];
                    try {
                        nor.loadPlugin(classname);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            ++i;
        }
        try {
            nor.start();
            System.in.read();
            nor.close();
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
        LOGGER.exiting("main");
    }
}

