
function classCode(){
	// 投薬方法コード "1","6" を返す
	return document.getElementById("_type").value;
}

var _records;
function setRecords(array){
	// 読込まれたレコードを記憶
	_records = array;
}
function records(){
	return _records;
}
function recordAtIndex(num){
	return _records[num];
}

///////////////////////////
/// Ajax による処理 /////////

function searched(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("searched ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var objects = eval('(' + array[1] + ')');
			setRecords(objects);
			showResult();
		}
		hideMessage("_message");
	} else 
		showMessage("_message", "サーバで処理中です ...");
}
function search(){
	// 検索キーによりデータを検索
	var key = document.getElementById("key").value;
	var effectCode = document.getElementById("effectCode").value;
	if ((key.length == 0) && (effectCode.length == 0)) return;
	
	xmlHttpObject = createXMLHttpRequest(searched);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["classCode"] = classCode();
		array["name"] = key;
		array["effectCode"] = effectCode;
		
		var st = "./priceListServer.php?command=GET_GLOBAL_PRICE"
		+ "&value=" + encodeSTRING(encodeObject(array));
		//alert(st); //return; //===
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function puttedPriceList(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("puttedPriceList ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var buff = array[1];
			//alert(buff);
			window.opener.putGlobal(buff); // ### prescription.js
			window.close();
		}
		hideMessage("_message");
	} else 
		showMessage("_message", "サーバで処理中です ...");
}
function putPriceList(obj){
	// PriceList に薬剤レコードをマージ
	xmlHttpObject = createXMLHttpRequest(puttedPriceList);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./priceListServer.php?command=PUT_PRICE_LIST"
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//alert(st); //return; //===
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

/// Ajax による処理 /////////
///////////////////////////

function sendRecord(buff){
	// 確定されたレコードをサーバに収納し Prescription に送る
	var obj = decodeObject(buff);
	// prescription 固有の値を追加
	obj.alias = document.getElementById("alias").value;
	obj.min = document.getElementById("min").value;
	obj.standard = document.getElementById("standard").value;
	obj.max = document.getElementById("max").value;
	obj.width = document.getElementById("width").value;
	obj.effectCode = document.getElementById("effectCode").value;
	obj.effect = document.getElementById("effect").value;
	obj.memo = document.getElementById("memo").value;
	obj.dose = obj.standard;
	obj.unit = obj.unitName;
	
	// PriceList に obj をマージした後、処方に追加記載
	putPriceList(obj);
}

function clickedRow(row){
	// レコードが選択された
	var elm = document.getElementById("_confirm");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "confirmTable");
	
	var obj = recordAtIndex(row);
	
	//alert(encodeObject(obj)); //##

	var tr = newTR(tbl, "", "code");
	var td = newTD(tr, "", obj.code);
	
	var tr = newTR(tbl, "", "請求コード");
	var td = newTD(tr, "", obj.requestCode);
	
	var tr = newTR(tbl, "", "name");
	var td = newTD(tr, "", obj.name);
	
	var tr = newTR(tbl, "", "alias");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "alias", "", 30, "");
	
	var tr = newTR(tbl, "", "薬価");
	var td = newTD(tr, "", obj.point);
	
	var tr = newTR(tbl, "", "最小投与量");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "min", "", 5, "");
	var tx = newTEXT(td, obj.unitName);
	
	var tr = newTR(tbl, "", "標準投与量");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "standard", "", 5, "");
	var tx = newTEXT(td, obj.unitName);
	
	var tr = newTR(tbl, "", "最大投与量");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "max", "", 5, "");
	var tx = newTEXT(td, obj.unitName);
	
	var tr = newTR(tbl, "", "投与巾");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "width", "", 5, "1");
	var tx = newTEXT(td, obj.unitName);
	
	var tr = newTR(tbl, "", "薬効コード");
	var td = newTD(tr, "", obj.effectCode);
	
	var tr = newTR(tbl, "", "薬効");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "effect", "", 30, "");
	
	var tr = newTR(tbl, "", "メモ");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "memo", "", 30, "");
	
	var tr = newTR(tbl, "", " ");
	var td = newTD(tr, "", "この薬剤を処方に ");
	td.style.textAlign = "right";
	td.style.color = "#930";
	var bt = newBUTTON(td, "", "追加");
	var action = "sendRecord('" + encodeObject(obj) + "')"
	bt.setAttribute("onclick", action);
	
	// 上端にスクロールし編集パネルを開く
	window.scroll(0, 0);
	openFloatPanel(tbl, 30, 60, "確認パネル");
}

function showResult(){
	var elm = document.getElementById("resultArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "contentsTable");
	
	// title
	var tr = newTR(tbl, "", "");
	tr.style.backgroundColor = "#6c9";
	var td = newTD(tr, "", "code");
	var td = newTD(tr, "", "classCode");
	var td = newTD(tr, "", "requestCode");
	var td = newTD(tr, "", "name");
	var td = newTD(tr, "", "point");
	var td = newTD(tr, "", "unitCode");
	var td = newTD(tr, "", "unitName");
	var td = newTD(tr, "", "effectCode");
	
	// records
	var array = records();
	for (var i=0,ct=array.length; i < ct; i++){
		var obj = array[i];
		var tr = newTR(tbl, "record", "");
		tr.setAttribute("onmouseout","resetColor(this,'#000','#fff')");
		tr.setAttribute("onmouseover","setColor(this,'#ff0','#00f')");
		var action = "clickedRow("+i+")";
		tr.setAttribute("onclick", action);
		
		var td = newTD(tr, "", obj.code);
		var td = newTD(tr, "", obj.classCode);
		var td = newTD(tr, "", obj.requestCode);
		var td = newTD(tr, "", obj.name);
		var td = newTD(tr, "", obj.point);
		var td = newTD(tr, "", obj.unitCode);
		var td = newTD(tr, "", obj.unitName);
		var td = newTD(tr, "", obj.effectCode);
	}
}

function clickedEffect(elm){
	// 薬効ポップアップが選択された
	var st = elm.value;
	var array = st.split(" ");
	document.getElementById("effectCode").value = array[0];
}

function effects(){
	// 薬効の配列を返す
	return ["","214 降圧剤","332 止血剤","520 漢方薬","624 抗生剤"];
}

function initGlobalList(){
	// PriceListGlobal から薬剤を選択するパネルを表示
	// type: 21内用 22頓用 23外用
	var elm = document.getElementById("base");
	var tbl = newTABLE(elm, "baseTable");
	
	// 検索エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "controlArea", type());
	var fd = newFIELD(td, "key", "name ", 20, "");
	var tx = newTEXT(td, "　effect");
	var pu = makePopupMenu(td, "effectPop", effects(), "");
	pu.setAttribute("onchange","clickedEffect(this)");
	var fd = newFIELD(td, "effectCode", "", 10, "");
	var bt = newBUTTON(td, "", "検索");
	bt.setAttribute("onclick","search()");
	
	
	// レコード表示エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "resultArea", "");
	
	// footer
	var tr = newTR(tbl, "footer", "");
	var td = newTD(tr, "footer", version());
	
	// メッセージ・エリア
	var dv = newDIV(elm, "message");
	
	function type(){
		// 用法の種別を返す
		return (classCode() == "6") ? "外用薬　" : "内服薬　";
	}
}