
/////////////////////////////////////////////////////////
/// Ajax による処理 ///////////////////////////////////////

function gotArchive(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			// ### JSON に含まれる改行を encode してから eval する
			var val = transferCR(array[1]);
			var obj = eval('(' + val + ')');
            
			// ### object 中の encode された改行を decode する
			obj = decodeEncodedCR(obj);
            //alert("gotArchive->"+encodeObject(obj)); //##
			
            setMenuObjects(obj);
            
            showRecords();
		} else {
            alert("gotArchive *** Error: "+value); //##
        }
	} 
	
	function decodeEncodedCR(array){
		// obj 中の encode された改行を decode する
		for (var i=0,ct=array.length; i < ct; i++){
			var newObj = new Object();
			var obj = array[i];
			for (key in obj){
				var val = obj[key];
				newObj[key] = transferToCR(val);
			}
			array[i] = newObj;
		}
		return array;
	}
}
function getArchive(path){
	// 選択されたユーザのバックアップ・データをサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(gotArchive);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['owner'] = document.getElementById("userPopup").value;
		array['tableType'] = "MENU";
		array['filename'] = path;
		var val = encodeObject(array);
		
		var st = "sysServer.php?command=GET_ARCHICE"
		+ "&value=" + encodeSTRING(val);
		//alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function gotTable(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//if (debugMode()) alert(value); //##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var obj = eval('(' + array[1] + ')');
			obj = pureRecords(obj); // $row の数値添字を取り除く
			//if (debugMode()) alert("gotTable:"+encodeObject(obj)); //##
            setMenuObjects(obj);
			showRecords();
			showMessageBar("");
		} else
			showMessageBar(value);
	} else 
		showMessageBar("Loading MenuTable ...");
	
	function pureRecords(objects){
		// $row の数値添字を取り除く
		var recs = new Array();
		for (var i=0,ct=objects.length; i < ct; i++){
			var obj = objects[i];
			var array = new Array();
			for (key in obj){
				if (! isDigit(key)) array[key] = obj[key];
			}
			recs.push(array);
		}
		return recs;
	}
}
function getTable(owner, table, order){
	// table の内容をサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(gotTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['owner'] = owner;
		array['table'] = table;
		array['order'] = order;
		var val = encodeObject(array);
		
		var st = "sysServer.php?command=GET_TABLE_SOURCE"
		+ "&value=" + encodeSTRING(val);
        
        document.getElementById("message").innerHTML = st;
        //alert("getTable->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function loadedBackupedArchive(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("loadedBackupedArchive ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);
            
            // バックアップファイルのポップアップを表示
            showBackupSelector(obj);
		}
	} 
}
function loadBackupedArchive(){
    // バックアップ・ファイル名リストをリクエスト
    //alert("loadBackupedArchive:"+owner); //##
	xmlHttpObject = createXMLHttpRequest(loadedBackupedArchive);
	if (xmlHttpObject){
		var array = new Array();
		array['owner'] = document.getElementById("userPopup").value;
		array['folder'] = "MENU_SOURCE";
		var args = encodeObject(array);
		
		var st = "./sysServer.php?command=GET_ARCHIVED_LIST"
		+ "&value=" + encodeSTRING(args);
		//alert(st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function mergedWithMenu(){
	// 各テーブルの存在がチェックされた
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert(value);//### メニュー項目１つずつの返事が返ってくるのでかなり頻繁
		var array = value.split("<SEPARATOR>");
		if ((array.length > 1) && (array[1].length)){
			showMessage("_message", value);
            //if (debugMode()) _debug("<p>"+value+"</p>"); //##
		} 
		mergeCycle();
	} 
}
function mergeWithMenu(obj){
	// データ・ソースを DB とマージ
	xmlHttpObject = createXMLHttpRequest(mergedWithMenu);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// ## obj に含まれた owner は操作者のものなので userPopup2 の値を指定する
        var owner = document.getElementById("userPopup2").value;
        obj.owner = owner;
        
		var st = "./sysServer.php?command=MERGE_MENU"
		+ "&owner=" + document.getElementById("userPopup2").value
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//alert(st); return;//## かなり頻繁
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function replacedMenuTable(){
	// DB の MenuTable が空になった
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//if (debugMode()) alert(value); //##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			mergeCycle();
		} 
	} 
}
function replaceMenuTable(){
	// DB の MenuTable を空にしてからデータソースを書込む
	xmlHttpObject = createXMLHttpRequest(replacedMenuTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['owner'] = document.getElementById("userPopup2").value;
		array['table'] = "MenuTable";
		var val = encodeObject(array);
		
		var st = "./sysServer.php?command=CLEAR_TABLE"
		+ "&value=" + encodeSTRING(val);
		//if (debugMode()) alert(st); //##
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function removedTable(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//if (debugMode()) alert(value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			showRecords();
		} 
	} 
}
function removeMenuTable(obj){
	// obj を PriceList から削除
	xmlHttpObject = createXMLHttpRequest(removedTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var rec = new Object();
        // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
		rec['owner'] = obj[0];
		rec['tag'] = obj[1];
		rec['menu'] = obj[2];
		
		var st = "./sysServer.php?command=REMOVE_MENU"
		+ "&value=" + encodeSTRING(encodeObject(rec));
        
		//if (debugMode()) alert(st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), false);
		xmlHttpObject.send(null);
	}
}

function puttedMenuTable(obj){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//if (debugMode()) alert("puttedMenuTable:\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // DB 内容を再表示
            var logname = document.getElementById("userPopup").value;
            var tableName = "MenuTable";
            var order = "`tag`,`menu`";
            getTable(logname, tableName, order);
		} 
	} 
}
function putMenuTable(obj){
	// obj を MenuTable に追加
	// MenuTable に同じ tag, emnu があれば上書き
	xmlHttpObject = createXMLHttpRequest(puttedMenuTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// ## obj に含まれた owner は操作者のものなので userPopup の値を指定する
        var owner = document.getElementById("userPopup").value;
        obj.owner = owner;

		var st = "./sysServer.php?command=PUT_MENU"
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//if (debugMode()) alert(st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), false);
		xmlHttpObject.send(null);
	}
}

/// Ajax による処理 ///////////////////////////////////////
/////////////////////////////////////////////////////////

var _menuRecords;
function setMenuObjects(objct){
    // レコード数が１００を超えるほどになると処理がコケるので
    // なるべく軽くするためオブジェクト形式を配列形式に変換
    _menuRecords = new Array();
//    alert("setMenuObjects->"+encodeObject(objct)); //##
    for (num in objct){
        var items = new Array();
        var obj = objct[num];
        // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
        items.push(obj.owner);
        items.push(obj.tag);
        items.push(obj.menu);
        items.push(obj.value);
        items.push(obj.public);
        items.push(obj.freq);
        _menuRecords.push(items);
    }
}
function setMenuRecords(array){
    _menuRecords = array;
}
function menuRecords(){
	return _menuRecords;
}

function load(){
	// ユーザポップアップとソースポップアップに応じたデータを読込む
    var logname = document.getElementById("userPopup").value;
	var src = document.getElementById("sourcePopup").value;

    if (src == "テンプレート"){
        // バックアップデータを表示
        var filename = "./MENU.txt";
        showController("テンプレート ( " + filename + " ) ");

        getArchive(filename);
    } else if (src == "バックアップ"){
        // 過去ログからピックアップ
        var filename = document.getElementById("filePop").value;
        showController(logname + " 用バックアップ ( " + filename + " ) ");
        
        getArchive(filename);
    } else if (src == "データベース"){
        showController(logname + " 用データベース ");
        
		var tableName = "MenuTable";
		var order = "`tag`,`menu`";
        getTable(logname, tableName, order);
    }
}

var _archive;
var _archiveName;
function putArchive(filename){
	// データ・ソースを文字列ファイルとして保存	
	//alert("archive->"+filename); //return; //##
	var recs = menuRecords();
	if (! recs){
		alert("データ・ソースが読み込まれていません");
		return;
	}
    
	//alert(filename+" archive->"+encodeObject(recs)); //return; //##
	
	var array = new Array();
    for (i in recs){
		var ary = recs[i];
        // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
        var obj = new Object();
        obj.owner = ary[0];
        obj.tag = ary[1];
        obj.menu = ary[2];
        obj.value = ary[3];
        obj.public = ary[4];
        obj.freq = ary[5];
		array.push(object2json(obj));
	}
	
	//alert("array->"+encodeObject(array)); return; //##
	
	// [{"owner":"","tag":"","menu":"",,},{"owner":"",,},,] 形式
	var val = "[" + array.join(",") + "]";
	
	_archive = val;
	_archiveName = filename;
	//alert(filename+"->"+val); return; //##
    
    _initDebug(false); //##
    
    archiveTableSource("C_L_E_A_T_E__F_I_L_E"); // サーバを新規ファイル受入れ状態にする
}

var _num;
function mergeCycle(){
	// Ajax で DB との間でリカーシブルに merge を行う
	var array = menuRecords();
	if (_num < array.length){
		var ary = array[_num++];
        // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
        var obj = new Object();
        obj.owner = ary[0];
        obj.tag = ary[1];
        obj.menu = ary[2];
        obj.value = ary[3];
        obj.public = ary[4];
        obj.freq = ary[5];
        mergeWithMenu(obj);
	} else {
        hideMessage("_message");

        // DB 内容を再表示
        var logname = document.getElementById("userPopup").value;
		var tableName = "MenuTable";
		var order = "`tag`,`menu`";
        getTable(logname, tableName, order);

		alert("データへの書込み終了しました");
    }
}
function save(){
	// ユーザポップアップとソースポップアップに応じたデータを書込む
	var src = document.getElementById("sourcePopup2").value;
	if (src == "バックアップ"){
		putArchive("MENU");
	} else if (src == "テンプレート"){
		putArchive("./MENU.txt");
	} else if (src == "データベース"){
		var elm = document.getElementById("isOverWrite");
        var st = (elm.checked)
        ? "ここに表示されたデータによって完全に置換されます"
        : "ここに表示されたデータとマージされます。すでに同じ tag, menu を持つレコードは置換されません。差分のみが追加されます。";
		
		if (confirm("データベースは、" + st)){
			// データ・ソースを DB とマージ
			//showMergeLog(); // マージのログを表示するエリアを用意
			_num = 0; // _num を 0 にセットしてから mergeCycle() を廻す
			if (elm && elm.checked)
				replaceMenuTable(); //## GROUP では実施しないこと ##
			else
				mergeCycle();
		}
	}
}

function find(){
	// 検索を実行
	var key = document.getElementById("keyF").value;
	var count = 0;
	var array = menuRecords();
    for (i in array){
		var obj = array[i];
		var tr = document.getElementById("row"+i);
		var found = false;
		if (key.length){
            // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
			var st = obj[1] + obj[2];
			if (st.indexOf(key) >= 0) found = true;
		}
		
		if (found){ // key が含まれていた行の色を変える
			tr.style.backgroundColor = "#ff0";
			count++;
		} else
			tr.style.backgroundColor = "#fff";
	}
	
	if (count){
		alert(count + " 個の該当レコードを見つけました。黄色い行が該当レコードです。スクロールしてみてください");
	} else if (key.length > 0){
		alert(key + " を含むレコードは見つかりませんでした");
    }
}

function removeCheckedRecords(){
	// チェックされたレコードをすべて削除
	var array = new Array();
	var recs = menuRecords();
    for (i in recs){
		var elm = document.getElementById("cb."+i);
		if (! elm.checked)
			array.push(recs[i]); // チェックの入らないものだけをピックアップ
	}
	setMenuRecords(array);
    showRecords();
}

function removeRecord(row){
	// row 行レコードを削除
	var array = menuRecords();
	var obj = array[row];
	if (confirm(obj[2] + " を削除していいですか")){
		array.splice(row, 1);
		
		setEditorId("");
		var elm = document.getElementById("directEdit");
		if (elm && elm.checked){
			// 直接データベースの obj を削除
			removeMenuTable(obj);
		} else
			showRecords();
	}
}

function changeRecord(row){
	// row 行レコードを変更
    // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
    var array = new Array();
    array[1] = document.getElementById("tag").value;
    array[2] = document.getElementById("menu").value;
    array[3] = document.getElementById("value").value;
    array[4] = document.getElementById("public").value;
    array[5] = document.getElementById("freq").value;
    
    // 新規レコードの場合もあるので obj は新たに起こしたものを使う
    menuRecords()[row] = array;
    
	setEditorId("");
    var elm = document.getElementById("directEdit");
    if (elm && elm.checked){
        // 直接データベースの obj を更新
        // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
        var obj = new Object();
        obj.tag = document.getElementById("tag").value;
        obj.menu = document.getElementById("menu").value;
        obj.value = document.getElementById("value").value;
        obj.public = document.getElementById("public").value;
        obj.freq = document.getElementById("freq").value;
        putMenuTable(obj);
    } else {
        showRecords();
    }
}

function showNewEditor(){
	// 新規レコード作成エディターを開く
	// ## 新規レコードボタンに showEditor(row) を action として設定しても
	// ## その時点では row が決まっていない可能性があるため、この機能を独立させる
	var row = menuRecords().length;
    openEditor(row);
}

function openEditor(row){
	// row 行レコードの編集パネルを開く
	var obj = menuRecords()[row];
	if (!obj){
        obj = new Array();
        // 0:owner 1:tag 2:menu 3:value 4:public 5:freq
        obj.push("");
        obj.push("新規レコード"); // 1:tag
        obj.push("");
        obj.push("");
        obj.push("");
        obj.push("");
        // obj は「変更」ボタンが押されてから menuRecords に追加される
	}
    //alert("openEditor->"+encodeObject(obj)); //##
	
	// 以前開いていたエディターあれば閉じる
	var old_eid = editorId();
	var isClosed = closeEditor();
	
	// 目的エディターが今閉じたエディターなら、閉じただけで終了
	var eid = editorIdForRow(row);
	
	if (isClosed && (eid == old_eid)) return;
	
	// エディターを開く領域を記憶
	setEditorId(eid);
	
	// レコード編集ペーンを表示
	var elm = document.getElementById(eid);
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "subTable");
	tbl.style.border = "solid #fc0 5px";
	tbl.style.textAlign = "left";
	tbl.style.backgroundColor = "yellow";
	
	// title
	var tr = newTR(tbl, "editor_title", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan", "4");
	var img = newIMAGE(td, "icon", "./close.png", "close");
	img.setAttribute("onclick", "closeEditor()");
	var tx = newTEXT(td, "　" + obj[1] + " を編集"); // tag
	
	// contents
	makeField(tbl, "tag", obj[1], true);
	makeField(tbl, "menu", obj[2], true);
	makeField(tbl, "value", obj[3], true);
	makeField(tbl, "public", obj[4], true);
	makeField(tbl, "freq", obj[5], true);
	makeField(tbl, "owner", obj[0], false);
    
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var td = newTD(tr, "comment", "編集内容はバックアップやデータベースに書込まない限り保存されません ");
	td.setAttribute("colspan", "2");
	
	// footer
	var tr = newTR(tbl, "editor_title", "");
	var td = newTD(tr, "controller", "");
	td.setAttribute("colspan", "5");
	td.style.textAlign = "right";
	var dataSource = document.getElementById("sourcePopup").value;
	if (dataSource == "データベース"){
        var owner = document.getElementById("userPopup").value;
		var cb=newCHECKBOX(td,"directEdit",owner + " のデータベースを直接編集 ",false);
	}
	var bt = newBUTTON(td, "", "削除");
	var action = "removeRecord('" + row + "')";
	bt.setAttribute("onclick", action);
	var bt = newBUTTON(td, "", "変更");
	var action = "changeRecord('" + row + "')";
	bt.setAttribute("onclick", action);

    // Editor が見えないことがあるので該当位置へスクロールしておく
    var pos = getPosition(bt);
	window.scroll(0, pos.y);

	function makeField(tbl, key, value, status){
		var tr = newTR(tbl, "", key);
		if (status){
			var td = newTD(tr, "", "");
			var val = (value) ? value : "";
			var fd = newFIELD(td, key, "", "100", val);
		} else {
			var td = newTD(tr, "", value);
		}
	}
}

function checkAll(elm){
	// checkBox の全てにチェックを入れる
	var status = elm.checked;
	var recs = menuRecords();
    for (i in recs){
		var elm = document.getElementById("checkArea."+i);
		elm.innerHTML = "";
		var cb = newCHECKBOX(elm, "cb."+i, "", status);
	}
}

function showRecords(){
	// レコードを表示する
	var elm = document.getElementById("resultArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
	
	// title
	var tr = newTR(tbl, "title-bar", "");
	tr.style.fontSize = "11pt";
	var td = newTD(tr, "label-center", "");
	td.style.width = "10 px";
	var cb = newCHECKBOX(td, "", "", false);
	cb.setAttribute("onclick", "checkAll(this)");
	var td = newTD(tr, "label-left", "tag");
	var td = newTD(tr, "label-left", "menu");
	var td = newTD(tr, "label-left", "public");
	var td = newTD(tr, "label-left", "freq");
    
	var array = menuRecords();
    for (num in array){
        // if (num > 100) break;
		var ary = array[num];
		var tr = newTR(tbl, "row"+num, "");
        tr.style.fontSize = "10pt";
        
		// check box
		var td = newTD(tr, "checkArea."+num, "");
		td.style.width = "10 px";
		var cb = newCHECKBOX(td, "cb."+num, "", false);
		
		var td = newTD(tr, "", ary[1]); // tag
		td.setAttribute("onmouseout", "resetColor(this,'black','white')");
		td.setAttribute("onmouseover", "setColor(this, 'yellow', 'blue')");
		td.setAttribute("onclick", "openEditor('"+num+"')");
		
		var td = newTD(tr, "", ary[2]); // menu
		var td = newTD(tr, "", ary[4]); // public
		var td = newTD(tr, "", ary[5]); // freq
		
		// 編集エリアを生成しておく
		var eid = editorIdForRow(num);
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, eid, "");
		td.setAttribute("colspan", "6");
       
	}
	
	// 編集エリアを生成しておく
	var eid = editorIdForRow(array.length);
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, eid, "");
	td.setAttribute("colspan", "9");
	
	// save ボタンを表示
	showSaveButtons();
}

function showBackupSelector(filenames){
    // バックアップ・ファイルのリストを選択してファイルをロード
    var items = new Array();
    for (num in filenames){
        var name = filenames[num];
        if (name.charAt(0) == '.') continue;
        items.push(name);
    }
    var elm = document.getElementById("fileNamesArea");
    elm.innerHTML = "";
    var pu = makePopupMenu(elm, "filePop", items, "");
    
    // removeButtonArea の操作：バックアップファイルの削除ボタン
    var elm = document.getElementById("removeButtonArea");
    elm.innerHTML = " ";
    var bt = newBUTTON(elm, "", "サーバから削除");
    bt.setAttribute("onclick", "removeBackupFile('MENU')");
}

function initMenuTable(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    // HEADER
    var div = newDIV(elm, "");
	var tbl = newTABLE(div, "base-table");
	var tr = newTR(tbl, "title-bar", "");
    // TITLE
	var td = newTD(tr, "left-side", "");
    td.setAttribute("onclick", "suser()");
    var sp = newSPAN(td, "markArea");
    var tx = newTEXT(td, "MenuTable 編集");
	// HELP icon
	var td = newTD(tr, "right-side", "");
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "tableHelp()");
	im.style.height = "20px";
	im.style.verticalAlign = "bottom";

	// ロード・エリア
    var div = newDIV(elm, "loadButtonArea");
    div.style.paddingLeft = "10px";
	var sp = newSPAN(div, "userListArea"); // ユーザリストを表示
	var tx = newTEXT(div, " の ");
	var sp = newSPAN(div, "sourceListArea"); // データソースを表示
	var sp = newSPAN(div, "fileNamesArea"); // テンプレートのリストを表示
	var tx = newTEXT(div, " を ");
	var bt = newBUTTON(div, "", "読込む");
	bt.setAttribute("onclick", "load()");
	var sp = newSPAN(div, "removeButtonArea"); // テンプレートのリスト削除ボタン

	// セーブ・エリア
    var div = newDIV(elm, "saveButtonArea");
    div.style.paddingLeft = "10px";

    // データ表示エリア
    var div = newDIV(elm, "controlArea");

	// footer
    var div = newDIV(elm, "");
	var tbl = newTABLE(div, "base-table");
	var tr = newTR(tbl, "title-bar", "");
	var td = newTD(tr, "left-side", version());
	
	// ユーザ・ポップアップを読込む
	selectUserAndLoadStructure();
}

function version(){
	return "Ver.121021";
}
