

///////////////////////////////////////////////////////
///// Ajax ////////////////////////////////////////////

var _waitingRecords;

function sortBookingList(){
    // 受付日時で逆ソートする
    var status = (bookingReverse()) ? "" : "1";
    setBookingReverse(status);
    
    // 本日の受診者と、それ以後の予約者のリストをサーバへリクエスト
    NRGetAcceptanceList(todayAndTime(), gotAcceptanceList);
}

function gotAcceptanceList(answer){
    //alert("gotAcceptanceList->"+answer); //##
    var obj = JSON.parse(answer);
    //alert("gotAcceptanceList->"+encodeObject(_waitingRecords)); //return; //##
    
    _waitingRecords = (bookingReverse()) ? obj.reverse() : obj;
    
    showWaitingList();
}
function showBookingList(){
    // 受診者リストを表示
    var elm = document.getElementById("_confirm");
    if (elm.innerHTML.length){
        closeFloatPanel();
        return;
    }
    
    // 本日の受診者と、それ以後の予約者のリストをサーバへリクエスト
    NRGetAcceptanceList(todayAndTime(), gotAcceptanceList);
}

///// Ajax ////////////////////////////////////////////
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////
///// Preferences /////////////////////////////////////

function bookingCheckChanged(elm){
    // 診療済のレコードを表示/非表示に切り替え
    setBookingCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function setBookingTodayCheanged(elm){
    // 本日のみ表示/非表示
    setBookingTodayCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function setCostColumnCheanged(elm){
    // 金額欄表示/非表示
    setCostColumnCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function insColumnCheckChanged(elm){
    // 保険証欄表示/非表示
    setInsColumnCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function showControls(){
    // フッター上のコントロール類を表示
    var elm = document.getElementById("controlBar");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    makeControls(elm);
}

function makeControls(ctrl){
    // フッター上のコントロール類を生成
    ctrl.innerHTML = "";
    
    // 適用
    var sp = newSPAN(ctrl, "");
    sp.style.marginLeft = "5px";
    sp.innerHTML = "予約者";
    sp.setAttribute("class", "reserved");
    var sp = newSPAN(ctrl, "");
    sp.style.marginLeft = "5px";
    sp.innerHTML = "診療待";
    sp.setAttribute("class", "accepted");
    var sp = newSPAN(ctrl, "");
    sp.innerHTML = "診療済";
    sp.setAttribute("class", "finished");
    var sp = newSPAN(ctrl, "");
    sp.style.color = "#fff";
    var cb = newCHECKBOX(sp, "", "診療済を非表示", bookingCheck());
    cb.setAttribute("onchange", "bookingCheckChanged(this)");
    var sp = newSPAN(ctrl, "");
    sp.style.color = "#fff";
    var cb = newCHECKBOX(sp, "", "本日のみ表示", bookingTodayCheck());
    cb.setAttribute("onchange", "setBookingTodayCheanged(this)");
    var cb = newCHECKBOX(sp, "", "金額", costColumnCheck());
    cb.setAttribute("onchange", "setCostColumnCheanged(this)");
    var cb = newCHECKBOX(sp, "", "保険証", insColumnCheck());
    cb.setAttribute("onchange", "insColumnCheckChanged(this)");
}

///// Preferences /////////////////////////////////////
///////////////////////////////////////////////////////


function openInsViewer(pid, date){
    // InsViewer を開く
    var args = "patientId=" + pid + "&currentDate=" + date;
    window.open("../InsViewer?" + args, "_blank");
}

function showWaitingList(){
    // 受診者リストを表示
    // localStorage の値によりソートするか逆ソートするかを決める
    var obj = _waitingRecords;
    
    var elm = window.top.noa.document.getElementById("_confirm");
	elm.innerHTML = "";
	elm.style.visibility = "visible";
	elm.style.left = 10; // 表示するx座標
	elm.style.top = 30; // 表示するy座標
	setFloatPanel(elm);
    
    var div = newDIV(elm, "");
    div.style.background = "#77f";
    div.style.border = "thin solid #44f";
    
    // === TITLE ===
	var tbl = newTABLE(div, "/bookingTable");
    var tr = newTR(tbl, "", "");
    tr.style.fontSize = "9pt";
    var td = newTD(tr, "bookingSortTab/bookingTitle", "受 付");
    td.style.width = "120px";
    td.setAttribute("onclick", "sortBookingList()");
    var td = newTD(tr, "/bookingTitle", "カルテ");
    td.style.width = "180px";
    if (costColumnCheck()){
        var td = newTD(tr, "/bookingTitle", "計");
        td.style.width = "50px";
    }
    if (insColumnCheck()){
        var td = newTD(tr, "/bookingTitle", "保険証");
        td.style.width = "70px";
    }
    
    var dv = newDIV(div, "");
	dv.style.height = "200px"; // パネルの高さ
	dv.style.overflow = "auto";
    var tbl = newTABLE(dv, "/bookingTable");
    
    // === RECORDS ===
    var ignoreFinished = bookingCheck(); // 診療済を非表示
    var total = 0;
    for (num in obj){
        var rec = obj[num];
        var isFinished = (rec.endTime && rec.endTime.toString().length) ? true : false;
        var isToday = isSameDate(rec.entryDate, today());
        
        if (ignoreFinished && isFinished) continue; // 診療済をスキップ
        if (bookingTodayCheck() && !isToday) continue; // 本日以外をスキップ
        
        var tr = newTR(tbl, "", "");
        // entryDate
        var td = newTD(tr, "/bookingColumn", rec.entryDate);
        td.style.width = "120px";
        if (rec.reserved * 1 > 0){
            td.setAttribute("class", "reserved"); // 予約
            var action = "opneLogChart(1,'" + rec.patientId + "','" + rec.kanjiName + "')"
        } else if (isFinished){
            td.setAttribute("class", "finished"); // 診療済み
            var action = "opneLogChart(1,'" + rec.patientId + "','" + rec.kanjiName + "')"
        } else {
            td.setAttribute("class", "accepted"); // 診療待ち
            var action = "opneLogChart(1,'" + rec.patientId + "','" + rec.kanjiName + "','addPage')"
        }
        // patientId
        var st = rec.patientId + " " + rec.kanjiName;
        var td = newTD(tr, "/bookingActor", st);
        td.style.width = "180px";
        td.setAttribute("onclick", action);
        
        //var td = newTD(tr, "", encodeObject(rec)); break;
        
        if (costColumnCheck()){
            // 合計欄
            var cost = (rec.endTime) ? rec.insFee * 1 + rec.ownFee  * 1 + "" : "";
            total += rec.insFee * 1 + rec.ownFee  * 1;
            var td = newTD(tr, "/bookingColumn", cost); // 合計
            td.style.textAlign = "right";
            td.style.width = "50px";
        }
        
        if (insColumnCheck()){
            // 保険証欄
            var td = newTD(tr, "/bookingActor", ""); // 保険証
            setScanDateWith(td, rec.scanDateTime);
            var action = "openInsViewer('"+rec.patientId+"','"+rec.entryDate+"')";
            td.setAttribute("onclick", action);
            td.style.width = "70px";
        }
    }

    if (costColumnCheck() && bookingTodayCheck()){
        // 本日のみの表示であれば合計を表示
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", "");
        var td = newTD(tr, "/bookingColumn", "total");
        td.style.textAlign = "right";
        var td = newTD(tr, "/bookingColumn", total + "");
        td.style.textAlign = "right";
    }
    
    // === FOOOTER ===
    var dv = newDIV(div, "");
    dv.style.background = "#55f";
    dv.style.fontSize = "9pt";
    // --- 設定コントロール類 ---
    var sp = newSPAN(dv, "bookingOpen");
    sp.setAttribute("onclick", "showControls()");
	var img = newIMAGE(sp, "", "./hammer.png", "?");
	img.style.height = "14px";
	img.style.verticalAlign = "middle";
    var ctrl = newDIV(dv, "controlBar/bookingControls");
    setInfoTip("bookingOpen", "摘要や初期設定を表示"); // HELP
    // --- CLOSe BUTTON ---
    var sp = newSPAN(dv, "");
    sp.style.padding = "4px 5px 0px 0px";
    sp.style.display = "inline";
    sp.style.float = "right";
    var bt = newDIV(sp, "/closeButton");
    bt.innerHTML = "X";
    bt.setAttribute("onclick", "closeFloatPanel()");
    
    function setScanDateWith(elm, filename){
        // filename から 日付を抽出して返す
        // filename = "03234202_20120113165123.JPG" 形式
        if (filename){
            elm.style.textAlign = "right";
            var array = filename.split("_");
            if (array.length == 2){
                var st = array[1];
                var yyyy = st.substr(0, 4);
                var mm = st.substr(4, 2);
                var dd = st.substr(6, 2);
                var hour = st.substr(8, 2);
                var min = st.substr(10, 2);
                var sec = st.substr(12, 2);
                var dateTime = yyyy+"-"+mm+"-"+dd+" "+hour+":"+min;
                
                var today = (currentDate()) ? currentDate() : todayAndTime();
                var pastDays = daysBetween(dateTime, today);
                if (pastDays > 30){
                    // 一定日数を越えたものは「経過日数」表示
                    elm.innerHTML = pastDays + " 日経過";
                } else {
                    elm.innerHTML = yyyy+"-"+mm+"-"+dd;
                }
            } else {
                elm.innerHTML = filename; // 本来このようなことは無いはず
            }
            return;
        }
        elm.innerHTML = "画像なし";
        elm.setAttribute("class", "bookingYellowActor"); // 黄色表示
    }
    
    function daysBetween(datetime1, datetime2){
        // datetime1, datetime2 間の日数を返す
        // 両日の０時０分０秒同士で計算するので、多少誤差が出る可能性あり
        var date1 = datetime1.substr(0, 10) + " 00:00:00";
        var date2 = datetime2.substr(0, 10) + " 00:00:00";
        var seconds = secondsBetween(date1, date2);
        
        return (seconds) ? seconds / (60 * 60 * 24) : 0;
    }
}
