
///////////////////////////////////////////////////////
///// Lib.js //////////////////////////////////////////

function encodeObject(obj){
	// obj を "key(value)" の文字列に encode して返す -- NOA format と呼ぶ
	// encode 方法として JSON 形式その他が考えられるが NOA format が最も軽いので採用
	// ### 現状では配列はサポートしていない
    var _leftbrackets = "^[^"; // encode 中で使う '('
    var _rightbrackets = "^]^"; // encode 中で使う ')'
    
	var buff = "";
	for (key in obj){
		var value = obj[key];
		if (typeof(value) == "object"){
			buff += key + "(" + encodeObject(value) +")";
		} else {
			// "(", ")" は特定文字にしておく（ decode する時に元へ戻す）
			value = convertSTRING(value, "(", _leftbrackets);
			value = convertSTRING(value, ")", _rightbrackets);
			
			buff += key + "(" + value +")";
		}
	}
	return buff;
    
    function convertSTRING(buff, from, to){
        // buff 中の from 文字すべてを to 文字に変換する
        if (!buff || (buff.length == 0)) return buff;
        buff = buff + ""; // 文字列にしておく必要あり
        if (buff.length == 0) return buff;
        
        var array = buff.split(from);
        if (array.length > 1) buff = array.join(to);
        return buff;
    }
}

function today(){
    // ここで指定した年月日の受診者をピックアップする
    var date = new Date();
    var yy = date.getYear();
    var mm = date.getMonth() + 1;
    var dd = date.getDate();
    if (yy < 2000) { yy += 1900; }
    
    return yy + "-" + mm + "-" + dd;
}

///// Lib.js //////////////////////////////////////////
///////////////////////////////////////////////////////

var xmlHttpObject = new XMLHttpRequest(); // function 内で call すると駄目のようだ

polling();

function gotAcceptedPatient(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // 受診者データを受け取る
            var results = JSON.parse(array[1]);
            
            // 本日の受診者リストを返す
            postMessage(results);
		}
	}
}
function polling(){
    // サーバへ dateTime() の受診者レコードをリクエスト: gotAcceptedPatient() で受取る
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        // 状態が変わった時に func: gotAcceptedPatient が実行される
        xmlHttpObject.onreadystatechange = gotAcceptedPatient;
        
        var array = new Array();
        array["dateTime"] = today();
        
        var st = "./server.php?command=GET_FRONT_ACCEPTANCE"
        + "&value=" + encodeObject(array);
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
    
    // 一定時刻ごとに再帰処理
    setTimeout(polling, 5000);
}


