/**
 *   datFileUtil
 * 
 *    []
 * 
 * 
 */
#include <QFile>
#include <QIODevice>
#include <QTextCodec>
#include <QTextStream>
#include <QMessageBox>
#include "datFileUtil.h"

/**
 *  RXgN^
 * 
 */
datFileUtil::datFileUtil()
{
    //
}

/**
 *  fXgN^
 * 
 */
datFileUtil::~datFileUtil()
{
    //
}

/**
 *  datt@CX^Cgo
 *   (datt@ĈPsڂ "<>"ȍ~Ƀt@Ci[ĂA̕𒊏o)
 * 
 */
QString datFileUtil::pickupDatFileTitle(const QString &arPath, const QString &arFileName)
{
    QFile datFile(arPath + "/" + arFileName);
    if (!datFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        // t@CI[v邱ƂłȂ...I
        return (arFileName);
    }

    QTextCodec  *codec = QTextCodec::codecForName("Shift-JIS");
    if (codec == 0)
    {
        // codec擾łȂ...I
        return (arFileName);
    }

    QTextStream in(&datFile);
    in.setCodec(codec);
    QString line = in.readLine();
    datFile.close();
    if (line.isEmpty())
    {
        // 1sڂǂݏoƂłȂ...I
        return (arFileName);
    }

    int     pos = line.lastIndexOf("<>");
    if (pos < 0)
    {
        // t@CtH[}bgႤ...H ^Cg̎擾łȂ̂ŏI
        return (arFileName);
    }
    return (line.mid((pos + 2)));
}

/**
 *  datt@CɊ܂܂Ă郌X (datt@C̍s𐔂邾...)
 * 
 */
int datFileUtil::checkResCount(const QString &arPath, const QString &arFileName)
{
    QFile datFile(arPath + "/" + arFileName);
    if (!datFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        // t@CI[v邱ƂłȂ...I
        return (0);
    }

    QTextCodec  *codec = QTextCodec::codecForName("Shift-JIS");
    if (codec == 0)
    {
        // codec擾łȂ...I
        return (0);
    }

    QTextStream in(&datFile);
    in.setCodec(codec);
    int count = 0;
    while (1)
    {
        QString line = in.readLine();
        if (line.isNull() == true)
        {
            break;
        }
        count++;
    }
    datFile.close();
    return (count);
}

/**
 *  datt@C̈ړs
 * 
 * 
 */
bool datFileUtil::moveDatFile(const QString &arSrcFile, bool isSameSrc, const QString &arDstFile, bool isSameDst)
{
    bool ret = false;
    if (isSameSrc == isSameDst)
    {
        // t@Cړ
        ret = QFile::rename(arSrcFile, arDstFile);
/**
        if (ret == false)
        {
            QMessageBox::critical(0, "Error(move File)", arSrcFile + " -> " + arDstFile + " ", QMessageBox::Ok, QMessageBox::Cancel);
        }
**/
    }
    else
    {
        // t@Cړ
        ret = copyFile(arSrcFile, isSameSrc, arDstFile, isSameDst, true);
    }
    return (ret);
}

/**
 *  datt@C̃Rs[s
 * 
 */
bool datFileUtil::copyDatFile(const QString &arSrcFile, bool isSameSrc, const QString &arDstFile, bool isSameDst)
{
    bool ret = false;
    if (isSameSrc == isSameDst)
    {
        // t@CRs[
        ret = QFile::copy(arSrcFile, arDstFile);
/**
        if (ret == false)
        {
            QMessageBox::critical(0, "Error(copy File)", arSrcFile + " -> " + arDstFile + " ", QMessageBox::Ok, QMessageBox::Cancel);
        }
**/
    }
    else
    {
        // t@CRs[
        ret = copyFile(arSrcFile, isSameSrc, arDstFile, isSameDst, false);
    }
    return (ret);
}

/**
 * 
 * 
 */
bool datFileUtil::copyFile(const QString &arSrcFile, bool isSameSrc, const QString &arDstFile, bool isSameDst, bool isRemoveSrcFile)
{

    // ǂݍރt@C̏...
    QFile inData(arSrcFile);
    bool ret = inData.open(QIODevice::ReadOnly | QIODevice::Text);
//    bool ret = inData.open(QIODevice::ReadOnly);
    if (ret == false)
    {
        return (false);
    }

    qint64 fileSize = inData.size();
    char *data = new char[fileSize + 2];

    // ot@C̏...
    if (QFile::exists(arDstFile) == true)
    {
        // Rs[t@Cꍇ͍폜
        QFile::remove(arDstFile);
    }
    QFile outData(arDstFile);
    ret = outData.open(QFile::WriteOnly | QFile::Truncate);
    if (ret == false)
    {
        inData.close();
        delete[] data;
        return (false);
    }

    qint64 readSize = inData.readLine(data, fileSize);
    while (readSize > 0)
    {
        if (data[readSize -1] == '\n')
        {
            data[readSize - 1] = '\0';
            readSize--;
        }
        if (data[readSize - 1] == '\r')
        {
            data[readSize - 1] = '\0';
            readSize--;
        }
       
        if (isSameDst == true)
        {
            readSize++;
            data[readSize - 1] = '\n';
        }
        else
        {
            readSize++;
            data[readSize - 1] = '\r';
            readSize++;
            data[readSize - 1] = '\n';
        }
        outData.write(data, readSize);
        readSize = inData.readLine(data, fileSize);        
    }

    /// ㏈...
    outData.close();
    inData.close();

    if (isRemoveSrcFile == true)
    {
        // Rs[t@Cꍇ͍폜
        QFile::remove(arDstFile);
    }
    delete[] data;
    return (true);
}

/**
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
